/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.impl.health.ContextHealthCheck;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
public class CamelMicroProfileContextCheck
implements HealthCheck,
CamelContextAware {
    @Inject
    CamelContext camelContext;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name("camel-context-check");
        builder.down();
        if (this.camelContext != null) {
            ContextHealthCheck chc = new ContextHealthCheck();
            chc.setCamelContext(this.camelContext);
            HealthCheck.Result result = chc.call();
            Map details = result.getDetails();
            builder.withData("name", details.get("context.name").toString());
            builder.withData("contextStatus", details.get("context.status").toString());
            if (result.getState().equals((Object)HealthCheck.State.UP)) {
                builder.up();
            }
        }
        return builder.build();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

