/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@org.apache.camel.spi.annotations.Component(value="microprofile-metrics")
public class MicroProfileMetricsComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private MetricRegistry metricRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.metricRegistry == null) {
            this.metricRegistry = MicroProfileMetricsHelper.getMetricRegistry(this.getCamelContext());
        }
        String metricsName = MicroProfileMetricsHelper.getMetricsName(remaining);
        MetricType metricsType = MicroProfileMetricsHelper.getMetricsType(remaining);
        return new MicroProfileMetricsEndpoint(uri, (Component)this, this.metricRegistry, metricsType, metricsName);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    protected void doStop() throws Exception {
        MicroProfileMetricsHelper.removeMetricsFromRegistry(this.metricRegistry, (metricID, metric) -> {
            Map tags = metricID.getTags();
            if (tags.containsKey("camelContext")) {
                return ((String)tags.get("camelContext")).equals(this.getCamelContext().getName());
            }
            return false;
        });
    }
}

