/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.event.notifier;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.component.microprofile.metrics.event.notifier.MicroProfileMetricsEventNotifierService;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.eclipse.microprofile.metrics.MetricRegistry;

public abstract class AbstractMicroProfileMetricsEventNotifier<T extends CamelEvent>
extends EventNotifierSupport
implements CamelContextAware {
    private final Class<T> eventType;
    private CamelContext camelContext;
    private MetricRegistry metricRegistry;

    public AbstractMicroProfileMetricsEventNotifier(Class<T> eventType) {
        this.eventType = eventType;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public boolean isEnabled(CamelEvent eventObject) {
        return this.eventType.isAssignableFrom(eventObject.getClass());
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.metricRegistry == null) {
            this.metricRegistry = MicroProfileMetricsHelper.getMetricRegistry(this.camelContext);
        }
        try {
            MicroProfileMetricsEventNotifierService service = (MicroProfileMetricsEventNotifierService)((Object)this.camelContext.hasService(MicroProfileMetricsEventNotifierService.class));
            if (service == null) {
                service = new MicroProfileMetricsEventNotifierService();
                service.setMetricRegistry(this.getMetricRegistry());
                this.camelContext.addService((Object)service);
                ServiceHelper.startService((Object)((Object)service));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

