/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import org.eclipse.microprofile.metrics.MetricRegistry;

@DevConsole(value="microprofile-metrics")
public class MicroProfileConsole
extends AbstractDevConsole {
    public MicroProfileConsole() {
        super("camel", "microprofile-metrics", "MicroProfile Metrics", "Display runtime metrics");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        MetricRegistry mr = (MetricRegistry)this.getCamelContext().getRegistry().findSingleByType(MetricRegistry.class);
        if (mr != null) {
            sb.append("Counters:\n");
            mr.getCounters().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                sb.append(String.format("    %s: %s\n", name, cnt));
            });
            sb.append("\nConcurrentGauges:\n");
            mr.getConcurrentGauges().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                long min = c.getMin();
                long max = c.getMax();
                sb.append(String.format("    %s: %s (min:%s max:%s)\n", name, cnt, max, min));
            });
            sb.append("\nGauges:\n");
            mr.getGauges().forEach((id, c) -> {
                String name = id.getName();
                Object val = c.getValue();
                sb.append(String.format("    %s: %s\n", name, val));
            });
            sb.append("\nHistograms:\n");
            mr.getHistograms().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                long sum = c.getSum();
                sb.append(String.format("    %s: %s (sum: %s)\n", name, cnt, sum));
            });
            sb.append("\nMeters:\n");
            mr.getMeters().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                double mean = c.getMeanRate();
                double r1 = c.getOneMinuteRate();
                double r5 = c.getFiveMinuteRate();
                double r15 = c.getFifteenMinuteRate();
                sb.append(String.format("    %s: %s (mean: %f 1min: %f 5min: %f 15min: %f)\n", name, cnt, mean, r1, r5, r15));
            });
            sb.append("\nSimpleTimers:\n");
            mr.getSimpleTimers().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                String dur = TimeUtils.printDuration((Duration)c.getElapsedTime(), (boolean)true);
                sb.append(String.format("    %s: %s (elapsed: %s)\n", name, cnt, dur));
            });
            sb.append("\nTimers:\n");
            mr.getTimers().forEach((id, c) -> {
                String name = id.getName();
                long cnt = c.getCount();
                String dur = TimeUtils.printDuration((Duration)c.getElapsedTime(), (boolean)true);
                double mean = c.getMeanRate();
                double r1 = c.getOneMinuteRate();
                double r5 = c.getFiveMinuteRate();
                double r15 = c.getFifteenMinuteRate();
                sb.append(String.format("    %s: %s (elapsed: %s mean: %f 1m: %f 5m: %f 15m: %f)\n", name, cnt, dur, mean, r1, r5, r15));
            });
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        MetricRegistry mr = (MetricRegistry)this.getCamelContext().getRegistry().findSingleByType(MetricRegistry.class);
        if (mr != null) {
            ArrayList list = new ArrayList();
            root.put((Object)"counters", list);
            mr.getCounters().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                list.add(jo);
            });
            ArrayList list2 = new ArrayList();
            root.put((Object)"concurrentGauges", list2);
            mr.getConcurrentGauges().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                jo.put((Object)"max", (Object)c.getMax());
                jo.put((Object)"min", (Object)c.getMin());
                list2.add(jo);
            });
            ArrayList list3 = new ArrayList();
            root.put((Object)"gauges", list3);
            mr.getGauges().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"value", c.getValue());
                list3.add(jo);
            });
            ArrayList list4 = new ArrayList();
            root.put((Object)"histograms", list4);
            mr.getHistograms().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                jo.put((Object)"sum", (Object)c.getSum());
                list4.add(jo);
            });
            ArrayList list5 = new ArrayList();
            root.put((Object)"meters", list5);
            mr.getMeters().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                jo.put((Object)"meanRate", (Object)c.getMeanRate());
                jo.put((Object)"rate1minute", (Object)c.getOneMinuteRate());
                jo.put((Object)"rate5minute", (Object)c.getFiveMinuteRate());
                jo.put((Object)"rate15minute", (Object)c.getFifteenMinuteRate());
                list5.add(jo);
            });
            ArrayList list6 = new ArrayList();
            root.put((Object)"simpleTimers", list6);
            mr.getSimpleTimers().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                jo.put((Object)"elapsedTimeMillis", (Object)c.getElapsedTime().toMillis());
                list6.add(jo);
            });
            ArrayList list7 = new ArrayList();
            root.put((Object)"timers", list7);
            mr.getTimers().forEach((id, c) -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)id.getName());
                jo.put((Object)"count", (Object)c.getCount());
                jo.put((Object)"elapsedTimeMillis", (Object)c.getElapsedTime().toMillis());
                jo.put((Object)"meanRate", (Object)c.getMeanRate());
                jo.put((Object)"rate1minute", (Object)c.getOneMinuteRate());
                jo.put((Object)"rate5minute", (Object)c.getFiveMinuteRate());
                jo.put((Object)"rate15minute", (Object)c.getFifteenMinuteRate());
                list7.add(jo);
            });
        }
        return root;
    }
}

