/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public final class MicroProfileMetricsHelper {
    private static final MetricType DEFAULT_METRIC_TYPE = MetricType.COUNTER;

    private MicroProfileMetricsHelper() {
    }

    public static String getMetricsName(String remaining) {
        String name = StringHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    public static MetricType getMetricsType(String remaining) {
        String type = StringHelper.before((String)remaining, (String)":");
        return type == null ? DEFAULT_METRIC_TYPE : MetricType.from((String)type.toLowerCase(Locale.US));
    }

    public static List<Tag> getMetricsTag(String rawTags) {
        if (rawTags != null && !rawTags.isEmpty()) {
            String[] tagStrings = rawTags.split("\\s*,\\s*");
            return Stream.of(tagStrings).map(tag -> MicroProfileMetricsHelper.parseTag(tag)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T extends Metric> T findMetric(MetricRegistry metricRegistry, String metricName, Class<T> metricType) {
        return MicroProfileMetricsHelper.findMetric(metricRegistry, metricName, metricType, Collections.emptyList());
    }

    public static <T extends Metric> T findMetric(MetricRegistry metricRegistry, String metricName, Class<T> metricType, List<Tag> tags) {
        Map metrics = metricRegistry.getMetrics();
        for (Map.Entry entry : metrics.entrySet()) {
            MetricID metricID;
            if (!MicroProfileMetricsHelper.metricTypeMatches((Metric)entry.getValue(), metricType) || !(metricID = (MetricID)entry.getKey()).getName().equals(metricName) || !tags.isEmpty() && !metricID.getTagsAsList().equals(tags)) continue;
            return (T)((Metric)metricType.cast(entry.getValue()));
        }
        return null;
    }

    public static Tag parseTag(String tagString) {
        if (ObjectHelper.isEmpty((String)tagString) || !tagString.contains("=")) {
            throw new IllegalArgumentException("Tag must be in the format: key=value");
        }
        String[] tagElements = tagString.split("=");
        if (tagElements.length != 2) {
            throw new IllegalArgumentException("Tag must be in the format: key=value");
        }
        return new Tag(tagElements[0], tagElements[1]);
    }

    public static Tag[] parseTagArray(String[] tagStrings) {
        Tag[] tags = new Tag[tagStrings.length];
        int i = 0;
        for (String tagString : tagStrings) {
            tags[i] = MicroProfileMetricsHelper.parseTag(tagString);
            ++i;
        }
        return tags;
    }

    public static MetricRegistry getMetricRegistry(CamelContext camelContext) {
        Registry camelRegistry = camelContext.getRegistry();
        MetricRegistry metricRegistry = (MetricRegistry)camelRegistry.lookupByNameAndType("metricRegistry", MetricRegistry.class);
        if (metricRegistry == null) {
            throw new IllegalStateException("No usable MetricRegistry has been configured");
        }
        return metricRegistry;
    }

    public static synchronized void removeMetricsFromRegistry(MetricRegistry metricRegistry, MetricFilter filter) {
        if (metricRegistry != null) {
            metricRegistry.removeMatching(filter);
        }
    }

    private static boolean metricTypeMatches(Metric metric, Class<? extends Metric> metricType) {
        return metricType.isInstance(metric);
    }
}

