/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.route.policy;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsExchangeRecorder;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.component.microprofile.metrics.route.policy.MicroProfileMetricsRoutePolicyNamingStrategy;
import org.apache.camel.component.microprofile.metrics.route.policy.MicroProfileMetricsRoutePolicyService;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

public class MicroProfileMetricsRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private MetricRegistry metricRegistry;
    private MetricsStatistics statistics;
    private MicroProfileMetricsRoutePolicyNamingStrategy namingStrategy = MicroProfileMetricsRoutePolicyNamingStrategy.DEFAULT;
    private MicroProfileMetricsExchangeRecorder exchangeRecorder;

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public MicroProfileMetricsRoutePolicyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicroProfileMetricsRoutePolicyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void onInit(Route route) {
        super.onInit(route);
        if (this.metricRegistry == null) {
            this.metricRegistry = MicroProfileMetricsHelper.getMetricRegistry(route.getCamelContext());
        }
        this.exchangeRecorder = new MicroProfileMetricsExchangeRecorder(this.metricRegistry, this.namingStrategy.getName(route), this.namingStrategy.getTags(route));
        try {
            MicroProfileMetricsRoutePolicyService registryService = (MicroProfileMetricsRoutePolicyService)((Object)route.getCamelContext().hasService(MicroProfileMetricsRoutePolicyService.class));
            if (registryService == null) {
                registryService = new MicroProfileMetricsRoutePolicyService();
                registryService.setMetricRegistry(this.metricRegistry);
                route.getCamelContext().addService((Object)registryService);
                ServiceHelper.startService((Object)((Object)registryService));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        this.statistics = new MetricsStatistics(this.metricRegistry, route, this.getNamingStrategy());
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeBegin(exchange);
        }
        if (this.exchangeRecorder != null) {
            this.exchangeRecorder.recordExchangeBegin();
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeDone(exchange);
        }
        if (this.exchangeRecorder != null) {
            this.exchangeRecorder.recordExchangeComplete(exchange);
        }
    }

    public void onRemove(Route route) {
        super.onRemove(route);
        MicroProfileMetricsHelper.removeMetricsFromRegistry(this.metricRegistry, (metricID, metric) -> {
            Map tags = metricID.getTags();
            if (tags.containsKey("camelContext") && tags.containsKey("routeId")) {
                String camelContextName = (String)tags.get("camelContext");
                String routeId = (String)tags.get("routeId");
                return camelContextName.equals(route.getCamelContext().getName()) && routeId.equals(route.getId());
            }
            return false;
        });
    }

    private static final class MetricsStatistics {
        private final MetricRegistry metricRegistry;
        private final Route route;
        private final MicroProfileMetricsRoutePolicyNamingStrategy namingStrategy;

        private MetricsStatistics(MetricRegistry metricRegistry, Route route, MicroProfileMetricsRoutePolicyNamingStrategy namingStrategy) {
            this.metricRegistry = (MetricRegistry)ObjectHelper.notNull((Object)metricRegistry, (String)"metricRegistry", (Object)this);
            this.namingStrategy = (MicroProfileMetricsRoutePolicyNamingStrategy)ObjectHelper.notNull((Object)namingStrategy, (String)"MicroProfileMetricsRoutePolicyNamingStrategy", (Object)this);
            this.route = route;
        }

        public void onExchangeBegin(Exchange exchange) {
            String name = this.namingStrategy.getName(this.route);
            Timer timer = this.metricRegistry.timer(name + ".processing", this.namingStrategy.getTags(this.route));
            exchange.setProperty(this.propertyName(exchange), (Object)timer.time());
        }

        public void onExchangeDone(Exchange exchange) {
            Timer.Context context = (Timer.Context)exchange.removeProperty(this.propertyName(exchange));
            if (context != null) {
                context.stop();
            }
        }

        private String propertyName(Exchange exchange) {
            return String.format("%s.%s.%s", "camel.route", this.route.getId(), exchange.getExchangeId());
        }
    }
}

