/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import org.apache.camel.component.milo.client.MonitorFilterType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;

@UriParams
public class MonitorFilterConfiguration
implements Cloneable {
    @UriParam(description="Monitor Filter Type for MonitoredItems.")
    private MonitorFilterType monitorFilterType;
    @UriParam(defaultValue="0", description="Deadband type for MonitorFilterType DataChangeFilter.")
    private UInteger dataChangeFilterDeadbandType = UInteger.valueOf((int)0);
    @UriParam(defaultValue="0.0", description="Deadband value for MonitorFilterType DataChangeFilter.")
    private Double dataChangeFilterDeadbandValue = 0.0;
    @UriParam(description="Daata change trigger for data change monitor filter type.")
    private DataChangeTrigger dataChangeFilterTrigger = DataChangeTrigger.StatusValue;

    public MonitorFilterType getMonitorFilterType() {
        return this.monitorFilterType;
    }

    public void setMonitorFilterType(MonitorFilterType monitorFilterType) {
        this.monitorFilterType = monitorFilterType;
    }

    public UInteger getDataChangeFilterDeadbandType() {
        return this.dataChangeFilterDeadbandType;
    }

    public void setDataChangeFilterDeadbandType(UInteger dataChangeFilterDeadbandType) {
        this.dataChangeFilterDeadbandType = dataChangeFilterDeadbandType;
    }

    public Double getDataChangeFilterDeadbandValue() {
        return this.dataChangeFilterDeadbandValue;
    }

    public void setDataChangeFilterDeadbandValue(Double dataChangeFilterDeadbandValue) {
        this.dataChangeFilterDeadbandValue = dataChangeFilterDeadbandValue;
    }

    public DataChangeTrigger getDataChangeFilterTrigger() {
        return this.dataChangeFilterTrigger;
    }

    public void setDataChangeFilterTrigger(DataChangeTrigger dataChangeFilterTrigger) {
        this.dataChangeFilterTrigger = dataChangeFilterTrigger;
    }

    public MonitoringFilter createMonitoringFilter() {
        if (Objects.isNull((Object)this.monitorFilterType)) {
            throw new IllegalStateException("No filter type configured.");
        }
        switch (this.monitorFilterType) {
            default: 
        }
        return new DataChangeFilter(DataChangeTrigger.StatusValueTimestamp, this.getDataChangeFilterDeadbandType(), this.getDataChangeFilterDeadbandValue());
    }
}

