/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client.internal;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.milo.NodeIds;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MonitorFilterConfiguration;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.CompositeProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscriptionManager;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionManager.class);
    private final AtomicLong clientHandleCounter = new AtomicLong();
    private final MiloClientConfiguration configuration;
    private final ScheduledExecutorService executor;
    private final long reconnectTimeout;
    private Connected connected;
    private boolean disposed;
    private Future<?> reconnectJob;
    private final Map<UInteger, Subscription> subscriptions = new HashMap<UInteger, Subscription>();

    public SubscriptionManager(MiloClientConfiguration configuration, ScheduledExecutorService executor, long reconnectTimeout) {
        this.configuration = configuration;
        this.executor = executor;
        this.reconnectTimeout = reconnectTimeout;
        this.connect();
    }

    private synchronized void handleConnectionFailue(Throwable e) {
        if (this.connected != null) {
            this.connected.dispose();
            this.connected = null;
        }
        LOG.info("Connection failed", e);
        this.triggerReconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        LOG.info("Starting connect");
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            this.reconnectJob = null;
            if (this.disposed) {
                return;
            }
        }
        this.performAndEvalConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAndEvalConnect() {
        try {
            Connected connected = this.performConnect();
            LOG.debug("Connect call done");
            SubscriptionManager subscriptionManager = this;
            synchronized (subscriptionManager) {
                if (this.disposed) {
                    return;
                }
                try {
                    LOG.debug("Setting subscriptions: {}", (Object)this.subscriptions.size());
                    connected.putSubscriptions(this.subscriptions);
                    LOG.debug("Update state : {} -> {}", (Object)this.connected, (Object)connected);
                    Connected oldConnected = this.connected;
                    this.connected = connected;
                    if (oldConnected != null) {
                        LOG.debug("Dispose old state");
                        oldConnected.dispose();
                    }
                }
                catch (Exception e) {
                    LOG.info("Failed to set subscriptions", (Throwable)e);
                    connected.dispose();
                    throw e;
                }
            }
        }
        catch (Exception e) {
            LOG.info("Failed to connect", (Throwable)e);
            this.triggerReconnect(false);
        }
    }

    private Connected performConnect() throws Exception {
        String discoveryUri = this.getEndpointDiscoveryUri();
        URI uri = URI.create(this.getEndpointDiscoveryUri());
        String user = uri.getUserInfo();
        if (user != null && !user.isEmpty()) {
            discoveryUri = discoveryUri.replaceFirst(user + "@", "");
        }
        LOG.debug("Discovering endpoints from: {}", (Object)discoveryUri);
        EndpointDescription endpoint = (EndpointDescription)((CompletableFuture)DiscoveryClient.getEndpoints((String)discoveryUri).thenApply(endpoints -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found enpoints:");
                for (EndpointDescription ep : endpoints) {
                    LOG.debug("\t{}", (Object)ep);
                }
            }
            try {
                return this.findEndpoint((List<EndpointDescription>)endpoints);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to find endpoints", e);
            }
        })).get();
        LOG.debug("Selected endpoint: {}", (Object)endpoint);
        LinkedList<Object> providers = new LinkedList<Object>();
        if (user != null && !user.isEmpty()) {
            String[] creds = user.split(":", 2);
            if (creds != null && creds.length == 2) {
                LOG.debug("Enable username/password provider: {}", (Object)creds[0]);
            }
            providers.add(new UsernameProvider(creds[0], creds[1]));
        }
        providers.add(AnonymousProvider.INSTANCE);
        OpcUaClientConfigBuilder cfg = this.configuration.newBuilder();
        cfg.setIdentityProvider((IdentityProvider)new CompositeProvider(providers));
        cfg.setEndpoint(endpoint);
        OpcUaClient client = OpcUaClient.create((OpcUaClientConfig)cfg.build());
        client.connect().get();
        try {
            UaSubscription manager = (UaSubscription)client.getSubscriptionManager().createSubscription(this.configuration.getRequestedPublishingInterval().doubleValue()).get();
            client.getSubscriptionManager().addSubscriptionListener((UaSubscriptionManager.SubscriptionListener)new SubscriptionListenerImpl());
            return new Connected(client, manager);
        }
        catch (Exception e) {
            client.disconnect();
            throw e;
        }
    }

    private String getEndpointDiscoveryUri() {
        if (!Strings.isNullOrEmpty((String)this.configuration.getDiscoveryEndpointUri())) {
            return this.configuration.getDiscoveryEndpointUri();
        }
        if (!Strings.isNullOrEmpty((String)this.configuration.getDiscoveryEndpointSuffix())) {
            return this.configuration.getEndpointUri() + this.configuration.getDiscoveryEndpointSuffix();
        }
        return this.configuration.getEndpointUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Connected connected;
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            connected = this.connected;
        }
        if (connected != null) {
            connected.dispose();
        }
    }

    private synchronized void triggerReconnect(boolean immediate) {
        LOG.info("Trigger re-connect (immediate: {})", (Object)immediate);
        if (this.reconnectJob != null) {
            LOG.info("Re-connect already scheduled");
            return;
        }
        this.reconnectJob = immediate ? this.executor.submit(this::connect) : this.executor.schedule(this::connect, this.reconnectTimeout, TimeUnit.MILLISECONDS);
    }

    private EndpointDescription findEndpoint(List<EndpointDescription> endpoints) throws URISyntaxException {
        Set<String> uris = this.configuration.getAllowedSecurityPolicies();
        Predicate<String> allowed = this.configuration.getAllowedSecurityPolicies() == null || this.configuration.getAllowedSecurityPolicies().isEmpty() ? uri -> true : uris::contains;
        EndpointDescription best = null;
        for (EndpointDescription ep : endpoints) {
            if (!allowed.test(ep.getSecurityPolicyUri()) || best != null && ep.getSecurityLevel().compareTo(best.getSecurityLevel()) <= 0) continue;
            best = ep;
        }
        return this.overrideHost(best);
    }

    private EndpointDescription overrideHost(EndpointDescription desc) throws URISyntaxException {
        if (desc == null) {
            return null;
        }
        if (!this.configuration.isOverrideHost()) {
            return desc;
        }
        return new EndpointDescription(this.overrideHost(desc.getEndpointUrl()), desc.getServer(), desc.getServerCertificate(), desc.getSecurityMode(), desc.getSecurityPolicyUri(), desc.getUserIdentityTokens(), desc.getTransportProfileUri(), desc.getSecurityLevel());
    }

    private String overrideHost(String endpointUrl) throws URISyntaxException {
        if (endpointUrl == null) {
            return null;
        }
        URI uri = URI.create(endpointUrl);
        URI originalUri = URI.create(this.configuration.getEndpointUri());
        return new URI(uri.getScheme(), uri.getUserInfo(), originalUri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }

    protected synchronized void whenConnected(Worker<Connected> worker) {
        if (this.connected != null) {
            try {
                worker.work(this.connected);
            }
            catch (Exception e) {
                this.handleConnectionFailue(e);
            }
        }
    }

    private static <T> CompletableFuture<T> newNotConnectedResult() {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new IllegalStateException("No connected"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UInteger registerItem(ExpandedNodeId nodeId, Double samplingInterval, Consumer<DataValue> valueConsumer, MonitorFilterConfiguration monitorFilterConfiguration) {
        UInteger clientHandle = Unsigned.uint((long)this.clientHandleCounter.incrementAndGet());
        Subscription subscription = new Subscription(nodeId, samplingInterval, valueConsumer, monitorFilterConfiguration);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            this.subscriptions.put(clientHandle, subscription);
            this.whenConnected(connected -> connected.activate(clientHandle, subscription));
        }
        return clientHandle;
    }

    public synchronized void unregisterItem(UInteger clientHandle) {
        if (this.subscriptions.remove(clientHandle) != null) {
            this.whenConnected(connected -> connected.deactivate(clientHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<CallMethodResult> call(ExpandedNodeId nodeId, ExpandedNodeId methodId, Variant[] inputArguments) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (this.connected == null) {
                return SubscriptionManager.newNotConnectedResult();
            }
            return this.connected.call(nodeId, methodId, inputArguments).handleAsync((status, e) -> {
                if (e != null) {
                    this.handleConnectionFailue((Throwable)e);
                }
                return null;
            }, (Executor)this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> write(ExpandedNodeId nodeId, DataValue value) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (this.connected == null) {
                return SubscriptionManager.newNotConnectedResult();
            }
            return this.connected.write(nodeId, value).handleAsync((status, e) -> {
                if (e != null) {
                    this.handleConnectionFailue((Throwable)e);
                }
                return null;
            }, (Executor)this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> readValues(List<ExpandedNodeId> nodeIds) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (this.connected == null) {
                return SubscriptionManager.newNotConnectedResult();
            }
            return this.connected.readValues(nodeIds).handleAsync((nodes, e) -> {
                if (e != null) {
                    this.handleConnectionFailue((Throwable)e);
                }
                return nodes;
            }, (Executor)this.executor);
        }
    }

    private class Connected {
        private OpcUaClient client;
        private final UaSubscription manager;
        private final Map<UInteger, Subscription> badSubscriptions = new HashMap<UInteger, Subscription>();
        private final Map<UInteger, UaMonitoredItem> goodSubscriptions = new HashMap<UInteger, UaMonitoredItem>();
        private final Map<String, UShort> namespaceCache = new ConcurrentHashMap<String, UShort>();

        Connected(OpcUaClient client, UaSubscription manager) {
            this.client = client;
            this.manager = manager;
        }

        public void putSubscriptions(Map<UInteger, Subscription> subscriptions) throws Exception {
            if (subscriptions.isEmpty()) {
                return;
            }
            ArrayList<MonitoredItemCreateRequest> items = new ArrayList<MonitoredItemCreateRequest>(subscriptions.size());
            for (Map.Entry<UInteger, Subscription> entry : subscriptions.entrySet()) {
                Subscription s = entry.getValue();
                NodeId node = this.lookupNamespace(s.getNodeId()).get();
                if (node == null) {
                    this.handleSubscriptionError(new StatusCode(2158690304L), entry.getKey(), s);
                    continue;
                }
                ReadValueId itemId = new ReadValueId(node, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
                Double samplingInterval = s.getSamplingInterval();
                MonitoringParameters parameters = new MonitoringParameters(entry.getKey(), samplingInterval, s.createMonitoringFilter(this.client), null, null);
                items.add(new MonitoredItemCreateRequest(itemId, MonitoringMode.Reporting, parameters));
            }
            if (!items.isEmpty()) {
                this.manager.createMonitoredItems(TimestampsToReturn.Both, items, (item, idx) -> {
                    Subscription s = (Subscription)subscriptions.get(item.getClientHandle());
                    if (item.getStatusCode().isBad()) {
                        this.handleSubscriptionError(item.getStatusCode(), item.getClientHandle(), s);
                    } else {
                        this.goodSubscriptions.put(item.getClientHandle(), (UaMonitoredItem)item);
                        item.setValueConsumer(s.getValueConsumer());
                    }
                }).get();
            }
            if (!this.badSubscriptions.isEmpty()) {
                SubscriptionManager.this.executor.schedule(this::resubscribe, SubscriptionManager.this.reconnectTimeout, TimeUnit.MILLISECONDS);
            }
        }

        private void handleSubscriptionError(StatusCode statusCode, UInteger clientHandle, Subscription s) {
            this.badSubscriptions.put(clientHandle, s);
            s.getValueConsumer().accept(new DataValue(statusCode));
        }

        private void resubscribe() {
            HashMap<UInteger, Subscription> subscriptions = new HashMap<UInteger, Subscription>(this.badSubscriptions);
            this.badSubscriptions.clear();
            try {
                this.putSubscriptions(subscriptions);
            }
            catch (Exception e) {
                SubscriptionManager.this.handleConnectionFailue(e);
            }
        }

        public void activate(UInteger clientHandle, Subscription subscription) throws Exception {
            this.putSubscriptions(Collections.singletonMap(clientHandle, subscription));
        }

        public void deactivate(UInteger clientHandle) throws Exception {
            UaMonitoredItem item = this.goodSubscriptions.remove(clientHandle);
            if (item != null) {
                this.manager.deleteMonitoredItems(Collections.singletonList(item)).get();
            } else {
                this.badSubscriptions.remove(clientHandle);
            }
        }

        private CompletableFuture<UShort> lookupNamespaceIndex(String namespaceUri) {
            LOG.trace("Looking up namespace: {}", (Object)namespaceUri);
            UShort result = this.namespaceCache.get(namespaceUri);
            if (result != null) {
                LOG.trace("Found namespace in cache: {} -> {}", (Object)namespaceUri, (Object)result);
                return CompletableFuture.completedFuture(result);
            }
            LOG.debug("Looking up namespace on server: {}", (Object)namespaceUri);
            CompletableFuture future = this.client.readValue(0.0, TimestampsToReturn.Neither, Identifiers.Server_NamespaceArray);
            return future.thenApply(value -> {
                Object rawValue = value.getValue().getValue();
                if (rawValue instanceof String[]) {
                    String[] namespaces = (String[])rawValue;
                    for (int i = 0; i < namespaces.length; ++i) {
                        if (!namespaces[i].equals(namespaceUri)) continue;
                        UShort result = Unsigned.ushort((int)i);
                        this.namespaceCache.putIfAbsent(namespaceUri, result);
                        return result;
                    }
                }
                return null;
            });
        }

        public void dispose() {
            if (this.client != null) {
                this.client.disconnect();
                this.client = null;
            }
        }

        private CompletableFuture<NodeId> lookupNamespace(ExpandedNodeId nodeId) {
            LOG.trace("Expanded Node Id: {}", (Object)nodeId);
            String uri = nodeId.getNamespaceUri();
            if (uri != null) {
                LOG.trace("Looking up namespace: {}", (Object)uri);
                return this.lookupNamespaceIndex(uri).thenApply(index -> NodeIds.toNodeId(index, nodeId));
            }
            UShort index2 = nodeId.getNamespaceIndex();
            LOG.trace("Using provided index: {}", (Object)index2);
            return CompletableFuture.completedFuture(NodeIds.toNodeId(index2, nodeId));
        }

        public CompletableFuture<StatusCode> write(ExpandedNodeId nodeId, DataValue value) {
            return this.lookupNamespace(nodeId).thenCompose(node -> {
                LOG.debug("Node - expanded: {}, full: {}", (Object)nodeId, node);
                return this.client.writeValue(node, value).whenComplete((status, error) -> {
                    if (status != null) {
                        LOG.debug("Write to node={} = {} -> {}", new Object[]{node, value, status});
                    } else {
                        LOG.debug("Failed to write", error);
                    }
                });
            });
        }

        public CompletableFuture<CallMethodResult> call(ExpandedNodeId nodeId, ExpandedNodeId methodId, Variant[] inputArguments) {
            return this.lookupNamespace(nodeId).thenCompose(node -> {
                LOG.debug("Node   - expanded: {}, full: {}", (Object)nodeId, node);
                return this.lookupNamespace(methodId).thenCompose(method -> {
                    LOG.debug("Method - expanded: {}, full: {}", (Object)methodId, method);
                    CallMethodRequest cmr = new CallMethodRequest(node, method, inputArguments);
                    return this.client.call(cmr).whenComplete((status, error) -> {
                        if (status != null) {
                            LOG.debug("Call to node={}, method={} = {}-> {}", new Object[]{nodeId, methodId, inputArguments, status});
                        } else {
                            LOG.debug("Failed to call", error);
                        }
                    });
                });
            });
        }

        public CompletableFuture<List<DataValue>> readValues(List<ExpandedNodeId> expandedNodeIds) {
            CompletableFuture[] nodeIdFutures = (CompletableFuture[])expandedNodeIds.stream().map(this::lookupNamespace).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(nodeIdFutures).thenCompose(param -> {
                List nodeIds = Stream.of(nodeIdFutures).map(CompletableFuture::join).collect(Collectors.toList());
                return this.client.readValues(0.0, TimestampsToReturn.Server, nodeIds);
            });
        }
    }

    private static class Subscription {
        private final ExpandedNodeId nodeId;
        private final Double samplingInterval;
        private final Consumer<DataValue> valueConsumer;
        private MonitorFilterConfiguration monitorFilterConfiguration;

        Subscription(ExpandedNodeId nodeId, Double samplingInterval, Consumer<DataValue> valueConsumer, MonitorFilterConfiguration monitorFilterConfiguration) {
            this.nodeId = nodeId;
            this.samplingInterval = samplingInterval;
            this.valueConsumer = valueConsumer;
            this.monitorFilterConfiguration = monitorFilterConfiguration;
        }

        public ExpandedNodeId getNodeId() {
            return this.nodeId;
        }

        public Double getSamplingInterval() {
            return this.samplingInterval;
        }

        public Consumer<DataValue> getValueConsumer() {
            return this.valueConsumer;
        }

        public ExtensionObject createMonitoringFilter(OpcUaClient client) {
            if (Objects.isNull(this.monitorFilterConfiguration) || Objects.isNull((Object)this.monitorFilterConfiguration.getMonitorFilterType())) {
                return null;
            }
            MonitoringFilter monitorFilter = this.monitorFilterConfiguration.createMonitoringFilter();
            return ExtensionObject.encode((SerializationContext)client.getSerializationContext(), (UaStructure)monitorFilter);
        }
    }

    public static interface Worker<T> {
        public void work(T var1) throws Exception;
    }

    private final class SubscriptionListenerImpl
    implements UaSubscriptionManager.SubscriptionListener {
        private SubscriptionListenerImpl() {
        }

        public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
            LOG.info("Transfer failed {} : {}", (Object)subscription.getSubscriptionId(), (Object)statusCode);
            SubscriptionManager.this.handleConnectionFailue((Throwable)new RuntimeCamelException("Subscription failed to reconnect"));
        }

        public void onStatusChanged(UaSubscription subscription, StatusCode status) {
            LOG.info("Subscription status changed {} : {}", (Object)subscription.getSubscriptionId(), (Object)status);
        }

        public void onPublishFailure(UaException exception) {
        }

        public void onNotificationDataLost(UaSubscription subscription) {
        }

        public void onKeepAlive(UaSubscription subscription, DateTime publishTime) {
        }
    }
}

