/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.milo.client.MiloClientComponent;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientConsumer;
import org.apache.camel.component.milo.client.MiloClientProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;

@UriEndpoint(firstVersion="2.19.0", scheme="milo-client", syntax="milo-client:endpointUri", title="OPC UA Client", label="iot")
public class MiloClientEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private final String endpointUri;
    @UriParam
    private String node;
    @UriParam
    private String method;
    @UriParam(defaultValue="0.0")
    private Double samplingInterval = 0.0;
    @UriParam
    private MiloClientConfiguration configuration;
    @UriParam
    private boolean defaultAwaitWrites;
    private final MiloClientComponent component;
    private MiloClientConnection connection;

    public MiloClientEndpoint(String uri, MiloClientComponent component, String endpointUri) {
        super(uri, (Component)component);
        Objects.requireNonNull(component);
        Objects.requireNonNull(endpointUri);
        this.endpointUri = endpointUri;
        this.component = component;
    }

    public void setConfiguration(MiloClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public MiloClientConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.component.disposed(this);
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new MiloClientProducer(this, this.connection, this.defaultAwaitWrites);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MiloClientConsumer consumer = new MiloClientConsumer(this, processor, this.connection);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public MiloClientConnection getConnection() {
        return this.connection;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getNode() {
        return this.node;
    }

    ExpandedNodeId getNodeId() {
        if (this.node != null) {
            return ExpandedNodeId.parse((String)this.node);
        }
        return null;
    }

    ExpandedNodeId getMethodId() {
        if (this.method != null) {
            return ExpandedNodeId.parse((String)this.method);
        }
        return null;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(Double samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public boolean isDefaultAwaitWrites() {
        return this.defaultAwaitWrites;
    }

    public void setDefaultAwaitWrites(boolean defaultAwaitWrites) {
        this.defaultAwaitWrites = defaultAwaitWrites;
    }

    public void setConnection(MiloClientConnection connection) {
        this.connection = connection;
    }
}

