/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milvus.transform;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.UpsertParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Message;
import org.apache.camel.component.milvus.MilvusAction;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="milvus:embeddings", description="Prepares the message to become an object writable by Milvus component")
public class MilvusEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        String textFieldName = (String)message.getHeader("CamelMilvusTextFieldName", () -> "text", String.class);
        String vectorFieldName = (String)message.getHeader("CamelMilvusVectorFieldName", () -> "vector", String.class);
        String collectionName = (String)message.getHeader("CamelMilvusCollectionName", () -> "embeddings", String.class);
        String keyName = (String)message.getHeader("CamelMilvusKeyName", () -> "id", String.class);
        Object keyValue = message.getHeader("CamelMilvusKeyValue", () -> null);
        TextSegment text = (TextSegment)message.getBody(TextSegment.class);
        MilvusAction action = (MilvusAction)((Object)message.getHeader("CamelMilvusAction", MilvusAction.class));
        switch (action) {
            case INSERT: {
                MilvusEmbeddingsDataTypeTransformer.insertEmbeddingOperation(message, embedding, vectorFieldName, textFieldName, text, collectionName, keyValue, keyName);
                break;
            }
            case UPSERT: {
                MilvusEmbeddingsDataTypeTransformer.upsertEmbeddingOperation(message, embedding, vectorFieldName, textFieldName, text, collectionName, keyValue, keyName);
                break;
            }
            default: {
                throw new IllegalStateException("The only operations supported are insert and upsert");
            }
        }
    }

    private static void insertEmbeddingOperation(Message message, Embedding embedding, String vectorFieldName, String textFieldName, TextSegment text, String collectionName, Object keyValue, String keyName) {
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        ArrayList<List> list = new ArrayList<List>();
        list.add(embedding.vectorAsList());
        fields.add(new InsertParam.Field(vectorFieldName, list));
        fields.add(new InsertParam.Field(textFieldName, Collections.singletonList(text.text())));
        if (ObjectHelper.isNotEmpty((Object)keyValue) && ObjectHelper.isNotEmpty((String)keyName)) {
            ArrayList<Object> keyValues = new ArrayList<Object>();
            keyValues.add(keyValue);
            fields.add(new InsertParam.Field(keyName, keyValues));
        }
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(collectionName).withFields(fields).build();
        message.setBody((Object)insertParam);
    }

    private static void upsertEmbeddingOperation(Message message, Embedding embedding, String vectorFieldName, String textFieldName, TextSegment text, String collectionName, Object keyValue, String keyName) {
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        ArrayList<List> list = new ArrayList<List>();
        list.add(embedding.vectorAsList());
        fields.add(new InsertParam.Field(vectorFieldName, list));
        fields.add(new InsertParam.Field(textFieldName, Collections.singletonList(text.text())));
        if (ObjectHelper.isNotEmpty((Object)keyValue) && ObjectHelper.isNotEmpty((String)keyName)) {
            ArrayList<Object> keyValues = new ArrayList<Object>();
            keyValues.add(keyValue);
            fields.add(new InsertParam.Field(keyName, keyValues));
        }
        UpsertParam upsertParam = UpsertParam.newBuilder().withCollectionName(collectionName).withFields(fields).build();
        message.setBody((Object)upsertParam);
    }
}

