/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.10.0", scheme="mina", title="Mina", syntax="mina:protocol:host:port", category={Category.NETWORKING, Category.TCP, Category.UDP})
public class MinaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private MinaConfiguration configuration;

    public MinaEndpoint() {
    }

    public MinaEndpoint(String endpointUri, Component component, MinaConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public boolean isSingletonProducer() {
        return !this.configuration.isSync();
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        return new MinaProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        MinaConsumer answer = new MinaConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return this.configuration.isDatagramProtocol();
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }
}

