/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.io.InputStream;
import java.io.ObjectInput;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mina2.Mina2Converter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.mina.core.buffer.IoBuffer;

public final class Mina2ConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        Mina2ConverterLoader.addTypeConverter(registry, byte[].class, IoBuffer.class, false, (type, exchange, value) -> Mina2Converter.toByteArray((IoBuffer)value));
        Mina2ConverterLoader.addTypeConverter(registry, InputStream.class, IoBuffer.class, false, (type, exchange, value) -> Mina2Converter.toInputStream((IoBuffer)value));
        Mina2ConverterLoader.addTypeConverter(registry, ObjectInput.class, IoBuffer.class, false, (type, exchange, value) -> Mina2Converter.toObjectInput((IoBuffer)value));
        Mina2ConverterLoader.addTypeConverter(registry, String.class, IoBuffer.class, false, (type, exchange, value) -> Mina2Converter.toString((IoBuffer)value, exchange));
        Mina2ConverterLoader.addTypeConverter(registry, IoBuffer.class, byte[].class, false, (type, exchange, value) -> Mina2Converter.toIoBuffer((byte[])value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

