/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.minio.MinioComponentVerifierExtension;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="minio")
public class MinioComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MinioComponent.class);
    @Metadata
    private MinioConfiguration configuration = new MinioConfiguration();

    public MinioComponent() {
        this(null);
    }

    public MinioComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MinioComponentVerifierExtension());
    }

    protected MinioEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining) || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        MinioConfiguration configuration = ObjectHelper.isNotEmpty((Object)this.configuration) ? this.configuration.copy() : new MinioConfiguration();
        configuration.setBucketName(remaining);
        MinioEndpoint endpoint = new MinioEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }
}

