/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.util.ObjectHelper;

public class MinioComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public MinioComponentVerifierExtension() {
        this("minio");
    }

    public MinioComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"accessKey", parameters)).error(ResultErrorHelper.requiresOption((String)"secretKey", parameters)).error(ResultErrorHelper.requiresOption((String)"region", parameters));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            MinioConfiguration configuration = (MinioConfiguration)this.setProperties(new MinioConfiguration(), parameters);
            MinioClient.Builder clientBuilderRequest = MinioClient.builder();
            if (ObjectHelper.isEmpty((String)configuration.getEndpoint())) {
                ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER, (String)"The service endpoint has not defined");
                return builder.error(errorBuilder.build()).build();
            }
            if (ObjectHelper.isNotEmpty((Object)configuration.getProxyPort())) {
                clientBuilderRequest.endpoint(configuration.getEndpoint(), configuration.getProxyPort().intValue(), configuration.isSecure());
            } else {
                clientBuilderRequest.endpoint(configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion())) {
                clientBuilderRequest.region(configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)configuration.getSecretKey())) {
                clientBuilderRequest.credentials(configuration.getAccessKey(), configuration.getSecretKey());
            }
            MinioClient client = clientBuilderRequest.build();
            client.listBuckets();
        }
        catch (MinioException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("minio_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)((Object)((Object)e)).getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }
}

