/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.util.Objects;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mllp.MllpIdleTimeoutStrategy;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class MllpConfiguration
implements Cloneable {
    static final Logger LOG = LoggerFactory.getLogger(MllpConfiguration.class);
    @UriParam(label="consumer", defaultValue="true")
    boolean bridgeErrorHandler = true;
    @UriParam(label="consumer,advanced", defaultValue="InOut")
    ExchangePattern exchangePattern = ExchangePattern.InOut;
    @UriParam(label="advanced,consumer", defaultValue="5")
    Integer backlog = 5;
    @UriParam(label="advanced,consumer", defaultValue="30000")
    int bindTimeout = 30000;
    @UriParam(label="advanced,consumer", defaultValue="5000")
    int bindRetryInterval = 5000;
    @UriParam(label="advanced,consumer", defaultValue="false")
    boolean lenientBind;
    @UriParam(label="advanced,consumer", defaultValue="60000")
    int acceptTimeout = 60000;
    @UriParam(label="advanced,producer", defaultValue="30000")
    int connectTimeout = 30000;
    @UriParam(label="advanced", defaultValue="15000")
    int receiveTimeout = 15000;
    @UriParam(label="advanced,consumer", defaultValue="5")
    int maxConcurrentConsumers = 5;
    @UriParam(label="advanced,tcp", defaultValue="null")
    Integer idleTimeout;
    @UriParam(label="advanced", defaultValue="5000")
    int readTimeout = 5000;
    @UriParam(label="advanced,producer", defaultValue="true")
    Boolean keepAlive = true;
    @UriParam(label="advanced,producer", defaultValue="true")
    Boolean tcpNoDelay = true;
    @UriParam(label="advanced,consumer", defaultValue="false")
    Boolean reuseAddress = false;
    @UriParam(label="advanced", defaultValue="8192")
    Integer receiveBufferSize = 8192;
    @UriParam(label="advanced", defaultValue="8192")
    Integer sendBufferSize = 8192;
    @UriParam(defaultValue="true")
    boolean autoAck = true;
    @UriParam(defaultValue="true")
    boolean hl7Headers = true;
    @UriParam(defaultValue="true")
    boolean requireEndOfData = true;
    @UriParam(defaultValue="true")
    boolean stringPayload = true;
    @UriParam(defaultValue="false")
    boolean validatePayload;
    @UriParam
    String charsetName;
    @UriParam(label="advanced,producer", defaultValue="RESET")
    MllpIdleTimeoutStrategy idleTimeoutStrategy = MllpIdleTimeoutStrategy.RESET;

    public static void copy(MllpConfiguration source, MllpConfiguration target) {
        if (source == null) {
            LOG.warn("Values were not copied by MllpConfiguration.copy(MllpConfiguration source, MllpConfiguration target) - source argument is null");
        } else if (target == null) {
            LOG.warn("Values were not copied by MllpConfiguration.copy(MllpConfiguration source, MllpConfiguration target) - target argument is null");
        } else {
            target.bridgeErrorHandler = source.bridgeErrorHandler;
            target.exchangePattern = source.exchangePattern;
            target.backlog = source.backlog;
            target.bindTimeout = source.bindTimeout;
            target.bindRetryInterval = source.bindRetryInterval;
            target.acceptTimeout = source.acceptTimeout;
            target.connectTimeout = source.connectTimeout;
            target.receiveTimeout = source.receiveTimeout;
            target.idleTimeout = source.idleTimeout;
            target.idleTimeoutStrategy = source.idleTimeoutStrategy;
            target.readTimeout = source.readTimeout;
            target.keepAlive = source.keepAlive;
            target.tcpNoDelay = source.tcpNoDelay;
            target.reuseAddress = source.reuseAddress;
            target.receiveBufferSize = source.receiveBufferSize;
            target.sendBufferSize = source.sendBufferSize;
            target.autoAck = source.autoAck;
            target.hl7Headers = source.hl7Headers;
            target.requireEndOfData = source.requireEndOfData;
            target.stringPayload = source.stringPayload;
            target.validatePayload = source.validatePayload;
            target.charsetName = source.charsetName;
            target.maxConcurrentConsumers = source.maxConcurrentConsumers;
        }
    }

    public MllpConfiguration copy() {
        MllpConfiguration target = new MllpConfiguration();
        MllpConfiguration.copy(this, target);
        return target;
    }

    public void copy(MllpConfiguration source) {
        MllpConfiguration.copy(source, this);
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public boolean hasCharsetName() {
        return this.charsetName != null && !this.charsetName.isEmpty();
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean hasBacklog() {
        return this.backlog != null && this.backlog > 0;
    }

    public Integer getBacklog() {
        return this.backlog;
    }

    public void setBacklog(Integer backlog) {
        this.backlog = backlog;
    }

    public int getBindTimeout() {
        return this.bindTimeout;
    }

    public void setBindTimeout(int bindTimeout) {
        this.bindTimeout = bindTimeout;
    }

    public int getBindRetryInterval() {
        return this.bindRetryInterval;
    }

    public void setBindRetryInterval(int bindRetryInterval) {
        this.bindRetryInterval = bindRetryInterval;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public boolean isLenientBind() {
        return this.lenientBind;
    }

    public void setLenientBind(boolean lenientBind) {
        this.lenientBind = lenientBind;
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout != null && this.idleTimeout > 0;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean hasKeepAlive() {
        return this.keepAlive != null;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean hasTcpNoDelay() {
        return this.tcpNoDelay != null;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != null;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != null && this.receiveBufferSize > 0;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != null && this.sendBufferSize > 0;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isHl7Headers() {
        return this.hl7Headers;
    }

    public boolean getHl7Headers() {
        return this.isHl7Headers();
    }

    public void setHl7Headers(boolean hl7Headers) {
        this.hl7Headers = hl7Headers;
    }

    public boolean isRequireEndOfData() {
        return this.requireEndOfData;
    }

    public void setRequireEndOfData(boolean requireEndOfData) {
        this.requireEndOfData = requireEndOfData;
    }

    public boolean isStringPayload() {
        return this.stringPayload;
    }

    public void setStringPayload(boolean stringPayload) {
        this.stringPayload = stringPayload;
    }

    public boolean isValidatePayload() {
        return this.validatePayload;
    }

    public void setValidatePayload(boolean validatePayload) {
        this.validatePayload = validatePayload;
    }

    public MllpIdleTimeoutStrategy getIdleTimeoutStrategy() {
        return this.idleTimeoutStrategy;
    }

    public void setIdleTimeoutStrategy(MllpIdleTimeoutStrategy idleTimeoutStrategy) {
        this.idleTimeoutStrategy = idleTimeoutStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bridgeErrorHandler, this.exchangePattern, this.backlog, this.bindTimeout, this.bindRetryInterval, this.acceptTimeout, this.connectTimeout, this.receiveTimeout, this.maxConcurrentConsumers, this.idleTimeout, this.idleTimeoutStrategy, this.readTimeout, this.keepAlive, this.tcpNoDelay, this.reuseAddress, this.receiveBufferSize, this.sendBufferSize, this.autoAck, this.hl7Headers, this.requireEndOfData, this.stringPayload, this.validatePayload, this.charsetName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MllpConfiguration)) {
            return false;
        }
        MllpConfiguration rhs = (MllpConfiguration)o;
        return this.bridgeErrorHandler == rhs.bridgeErrorHandler && this.exchangePattern == rhs.exchangePattern && this.bindTimeout == rhs.bindTimeout && this.bindRetryInterval == rhs.bindRetryInterval && this.acceptTimeout == rhs.acceptTimeout && this.connectTimeout == rhs.connectTimeout && this.receiveTimeout == rhs.receiveTimeout && this.readTimeout == rhs.readTimeout && this.autoAck == rhs.autoAck && this.hl7Headers == rhs.hl7Headers && this.requireEndOfData == rhs.requireEndOfData && this.stringPayload == rhs.stringPayload && this.validatePayload == rhs.validatePayload && this.idleTimeoutStrategy == rhs.idleTimeoutStrategy && Objects.equals(this.backlog, rhs.backlog) && Objects.equals(this.maxConcurrentConsumers, rhs.maxConcurrentConsumers) && Objects.equals(this.idleTimeout, rhs.idleTimeout) && Objects.equals(this.keepAlive, rhs.keepAlive) && Objects.equals(this.tcpNoDelay, rhs.tcpNoDelay) && Objects.equals(this.reuseAddress, rhs.reuseAddress) && Objects.equals(this.receiveBufferSize, rhs.receiveBufferSize) && Objects.equals(this.sendBufferSize, rhs.sendBufferSize) && Objects.equals(this.charsetName, rhs.charsetName);
    }

    public String toString() {
        return "MllpConfiguration{bridgeErrorHandler=" + this.bridgeErrorHandler + ", exchangePattern=" + this.exchangePattern + ", backlog=" + this.backlog + ", bindTimeout=" + this.bindTimeout + ", bindRetryInterval=" + this.bindRetryInterval + ", acceptTimeout=" + this.acceptTimeout + ", connectTimeout=" + this.connectTimeout + ", receiveTimeout=" + this.receiveTimeout + ", maxConcurrentConsumers=" + this.maxConcurrentConsumers + ", idleTimeout=" + this.idleTimeout + ", idleTimeoutStrategy=" + (Object)((Object)this.idleTimeoutStrategy) + ", readTimeout=" + this.readTimeout + ", keepAlive=" + this.keepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", reuseAddress=" + this.reuseAddress + ", receiveBufferSize=" + this.receiveBufferSize + ", sendBufferSize=" + this.sendBufferSize + ", autoAck=" + this.autoAck + ", hl7Headers=" + this.hl7Headers + ", requireEndOfData=" + this.requireEndOfData + ", stringPayload=" + this.stringPayload + ", validatePayload=" + this.validatePayload + ", charsetName='" + this.charsetName + '\'' + '}';
    }
}

