/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="mllp")
public class MllpConsole
extends AbstractDevConsole {
    public MllpConsole() {
        super("camel", "mllp", "MLLP", "Embedded MLLP Server");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> c instanceof MllpTcpServerConsumer).collect(Collectors.toList());
        for (Consumer c2 : list) {
            MllpTcpServerConsumer nc = (MllpTcpServerConsumer)c2;
            sb.append(String.format("    mllp:%s:%d\n", nc.getEndpoint().getHostname(), nc.getEndpoint().getPort()));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> c instanceof MllpTcpServerConsumer).collect(Collectors.toList());
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        for (Consumer c2 : list) {
            MllpTcpServerConsumer nc = (MllpTcpServerConsumer)c2;
            JsonObject jo = new JsonObject();
            jo.put((Object)"protocol", (Object)"mllp");
            jo.put((Object)"host", (Object)nc.getEndpoint().getHostname());
            jo.put((Object)"port", (Object)nc.getEndpoint().getPort());
            arr.add(jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"endpoints", arr);
        }
        return root;
    }
}

