/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpConstants;
import org.apache.camel.component.mllp.MllpIdleTimeoutStrategy;
import org.apache.camel.component.mllp.MllpTcpClientProducer;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;

@ManagedResource(description="MLLP Endpoint")
@UriEndpoint(scheme="mllp", firstVersion="2.17.0", title="MLLP", syntax="mllp:hostname:port", category={Category.NETWORKING, Category.RPC, Category.MLLP}, generateConfigurer=true, headersClass=MllpConstants.class)
public class MllpEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    String hostname;
    @UriPath
    @Metadata(required=true)
    int port = -1;
    @UriParam(label="advanced")
    MllpConfiguration configuration;
    Long lastConnectionActivityTicks;
    Long lastConnectionEstablishedTicks;
    Long lastConnectionTerminatedTicks;

    public MllpEndpoint(String uri, MllpComponent component, MllpConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration.copy();
        super.setBridgeErrorHandler(configuration.isBridgeErrorHandler());
        super.setExchangePattern(configuration.getExchangePattern());
    }

    public MllpComponent getComponent() {
        return (MllpComponent)super.getComponent();
    }

    public Exchange createExchange(ExchangePattern exchangePattern) {
        Exchange mllpExchange = super.createExchange(exchangePattern);
        this.setExchangeProperties(mllpExchange);
        return mllpExchange;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.configuration.setExchangePattern(exchangePattern);
        super.setExchangePattern(this.configuration.getExchangePattern());
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.configuration.setBridgeErrorHandler(bridgeErrorHandler);
        super.setBridgeErrorHandler(this.configuration.isBridgeErrorHandler());
    }

    void setExchangeProperties(Exchange mllpExchange) {
        if (this.configuration.hasCharsetName()) {
            mllpExchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.configuration.getCharsetName());
        }
    }

    public Producer createProducer() throws Exception {
        return new MllpTcpClientProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MllpTcpServerConsumer consumer = new MllpTcpServerConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    @ManagedAttribute(description="Last activity time")
    public Date getLastConnectionActivityTime() {
        if (this.lastConnectionActivityTicks != null) {
            return new Date(this.lastConnectionActivityTicks);
        }
        return null;
    }

    @ManagedAttribute(description="Last connection established time")
    public Date getLastConnectionEstablishedTime() {
        if (this.lastConnectionEstablishedTicks != null) {
            return new Date(this.lastConnectionEstablishedTicks);
        }
        return null;
    }

    @ManagedAttribute(description="Last connection terminated time")
    public Date getLastConnectionTerminatedTime() {
        return this.lastConnectionTerminatedTicks != null ? new Date(this.lastConnectionTerminatedTicks) : null;
    }

    public boolean hasLastConnectionActivityTicks() {
        return this.lastConnectionActivityTicks != null && this.lastConnectionActivityTicks > 0L;
    }

    public Long getLastConnectionActivityTicks() {
        return this.lastConnectionActivityTicks;
    }

    public void updateLastConnectionActivityTicks() {
        this.updateLastConnectionActivityTicks(System.currentTimeMillis());
    }

    public void updateLastConnectionActivityTicks(long epochTicks) {
        this.lastConnectionActivityTicks = epochTicks;
    }

    public void updateLastConnectionEstablishedTicks() {
        this.lastConnectionEstablishedTicks = System.currentTimeMillis();
    }

    public void updateLastConnectionTerminatedTicks() {
        this.lastConnectionTerminatedTicks = System.currentTimeMillis();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public MllpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MllpConfiguration configuration) {
        if (this.hasConfiguration()) {
            this.configuration.copy(configuration);
        } else {
            this.configuration = configuration.copy();
        }
    }

    public void setBacklog(Integer backlog) {
        this.configuration.setBacklog(backlog);
    }

    public void setBindTimeout(int bindTimeout) {
        this.configuration.setBindTimeout(bindTimeout);
    }

    public void setBindRetryInterval(int bindRetryInterval) {
        this.configuration.setBindRetryInterval(bindRetryInterval);
    }

    public void setLenientBind(boolean lenientBind) {
        this.configuration.setLenientBind(lenientBind);
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.configuration.setAcceptTimeout(acceptTimeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.configuration.setConnectTimeout(connectTimeout);
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.configuration.setReceiveTimeout(receiveTimeout);
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.configuration.setIdleTimeout(idleTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.configuration.setReadTimeout(readTimeout);
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.configuration.setKeepAlive(keepAlive);
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.configuration.setTcpNoDelay(tcpNoDelay);
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.configuration.setReuseAddress(reuseAddress);
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.configuration.setReceiveBufferSize(receiveBufferSize);
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.configuration.setSendBufferSize(sendBufferSize);
    }

    public void setAutoAck(Boolean autoAck) {
        this.configuration.setAutoAck(autoAck);
    }

    public void setHl7Headers(Boolean hl7Headers) {
        this.configuration.setHl7Headers(hl7Headers);
    }

    public void setRequireEndOfData(Boolean requireEndOfData) {
        this.configuration.setRequireEndOfData(requireEndOfData);
    }

    public void setStringPayload(Boolean stringPayload) {
        this.configuration.setStringPayload(stringPayload);
    }

    public void setValidatePayload(Boolean validatePayload) {
        this.configuration.setValidatePayload(validatePayload);
    }

    public String getCharsetName() {
        return this.configuration.getCharsetName();
    }

    public void setCharsetName(String charsetName) {
        this.configuration.setCharsetName(charsetName);
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.configuration.setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    public void setIdleTimeoutStrategy(MllpIdleTimeoutStrategy strategy) {
        this.configuration.setIdleTimeoutStrategy(strategy);
    }

    public boolean checkBeforeSendProperties(Exchange exchange, Socket socket, Logger log) {
        String logMessageFormat = "Exchange property {} = {} - {} connection";
        boolean answer = true;
        boolean resetBeforeSend = (Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", (Object)false, Boolean.TYPE);
        if (resetBeforeSend) {
            log.warn("Exchange property {} = {} - {} connection", new Object[]{"CamelMllpResetConnectionBeforeSend", exchange.getProperty("CamelMllpResetConnectionBeforeSend"), "resetting"});
            this.doConnectionClose(socket, true, null);
            answer = false;
        } else {
            boolean closeBeforeSend = (Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", (Object)false, Boolean.TYPE);
            if (closeBeforeSend) {
                log.warn("Exchange property {} = {} - {} connection", new Object[]{"CamelMllpCloseConnectionBeforeSend", exchange.getProperty("CamelMllpCloseConnectionBeforeSend"), "closing"});
                this.doConnectionClose(socket, false, null);
                answer = false;
            }
        }
        return answer;
    }

    public boolean checkAfterSendProperties(Exchange exchange, Socket socket, Logger log) {
        String logMessageFormat = "Exchange property {} = {} - {} connection";
        boolean answer = true;
        boolean resetAfterSend = (Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", (Object)false, Boolean.TYPE);
        if (resetAfterSend) {
            log.warn("Exchange property {} = {} - {} connection", new Object[]{"CamelMllpResetConnectionAfterSend", exchange.getProperty("CamelMllpResetConnectionAfterSend"), "resetting"});
            this.doConnectionClose(socket, true, log);
            answer = false;
        } else {
            boolean closeAfterSend = (Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", (Object)false, Boolean.TYPE);
            if (closeAfterSend) {
                log.warn("Exchange property {} = {} - {} connection", new Object[]{"CamelMllpCloseConnectionAfterSend", exchange.getProperty("CamelMllpCloseConnectionAfterSend"), "closing"});
                this.doConnectionClose(socket, false, log);
                answer = false;
            }
        }
        return answer;
    }

    public void doConnectionClose(Socket socket, boolean reset, Logger log) {
        block27: {
            String ignoringCallLogFormat = "Ignoring {} Connection request because - {}: localAddress={} remoteAddress={}";
            if (socket == null) {
                if (log != null) {
                    log.debug(ignoringCallLogFormat, new Object[]{reset ? "Reset" : "Close", "Socket is null", "null", "null"});
                }
            } else {
                SocketAddress localSocketAddress = socket.getLocalSocketAddress();
                SocketAddress remoteSocketAddress = socket.getRemoteSocketAddress();
                if (!socket.isConnected()) {
                    if (log != null) {
                        log.debug(ignoringCallLogFormat, new Object[]{reset ? "Reset" : "Close", "Socket is not connected", localSocketAddress, remoteSocketAddress});
                    }
                } else if (socket.isClosed()) {
                    if (log != null) {
                        log.debug(ignoringCallLogFormat, new Object[]{reset ? "Reset" : "Close", "Socket is already closed", localSocketAddress, remoteSocketAddress});
                    }
                } else {
                    block26: {
                        block25: {
                            String logMessage;
                            block24: {
                                this.updateLastConnectionTerminatedTicks();
                                String ignoringExceptionStringFormat = "Ignoring %s encountered calling %s on Socket: localAddress=%s remoteAddress=%s";
                                if (!socket.isInputShutdown()) {
                                    if (log != null) {
                                        log.trace("Shutting down input on Socket: localAddress={} remoteAddress={}", (Object)localSocketAddress, (Object)remoteSocketAddress);
                                    }
                                    try {
                                        socket.shutdownInput();
                                    }
                                    catch (Exception ioEx) {
                                        if (log == null || !log.isDebugEnabled()) break block24;
                                        logMessage = String.format("Ignoring %s encountered calling %s on Socket: localAddress=%s remoteAddress=%s", ioEx.getClass().getSimpleName(), "shutdownInput()", localSocketAddress, remoteSocketAddress);
                                        log.debug(logMessage, (Throwable)ioEx);
                                    }
                                }
                            }
                            if (!socket.isOutputShutdown()) {
                                if (log != null) {
                                    log.trace("Shutting down output on Socket: localAddress={} remoteAddress={}", (Object)localSocketAddress, (Object)remoteSocketAddress);
                                }
                                try {
                                    socket.shutdownOutput();
                                }
                                catch (IOException ioEx) {
                                    if (log == null || !log.isDebugEnabled()) break block25;
                                    logMessage = String.format("Ignoring %s encountered calling %s on Socket: localAddress=%s remoteAddress=%s", ioEx.getClass().getSimpleName(), "shutdownOutput()", localSocketAddress, remoteSocketAddress);
                                    log.debug(logMessage, (Throwable)ioEx);
                                }
                            }
                        }
                        if (reset) {
                            boolean on = true;
                            boolean linger = false;
                            if (log != null) {
                                log.trace("Setting SO_LINGER to {} on Socket: localAddress={} remoteAddress={}", new Object[]{0, localSocketAddress, remoteSocketAddress});
                            }
                            try {
                                socket.setSoLinger(true, 0);
                            }
                            catch (IOException ioEx) {
                                if (log == null || !log.isDebugEnabled()) break block26;
                                String methodString = String.format("setSoLinger(%b, %d)", true, 0);
                                String logMessage = String.format("Ignoring %s encountered calling %s on Socket: localAddress=%s remoteAddress=%s", ioEx.getClass().getSimpleName(), methodString, localSocketAddress, remoteSocketAddress);
                                log.debug(logMessage, (Throwable)ioEx);
                            }
                        }
                    }
                    try {
                        if (log != null) {
                            log.trace("Resetting Socket: localAddress={} remoteAddress={}", (Object)localSocketAddress, (Object)remoteSocketAddress);
                        }
                        socket.close();
                    }
                    catch (IOException ioEx) {
                        if (log == null || !log.isDebugEnabled()) break block27;
                        String warningMessage = String.format("Ignoring %s encountered calling %s on Socket: localAddress=%s remoteAddress=%s", ioEx.getClass().getSimpleName(), "close()", localSocketAddress, remoteSocketAddress);
                        log.debug(warningMessage, (Throwable)ioEx);
                    }
                }
            }
        }
    }
}

