/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mongodb.converters.MongoDbBasicConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@DeferredContextBinding
public final class MongoDbBasicConvertersLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        MongoDbBasicConvertersLoader.addTypeConverter(registry, List.class, String.class, true, (type, exchange, value) -> MongoDbBasicConverters.fromStringToList((String)value));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Map.class, Document.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromDocumentToMap((Document)value));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Document.class, byte[].class, false, (type, exchange, value) -> MongoDbBasicConverters.fromByteArrayToDocument((byte[])value, exchange));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Document.class, File.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromFileToDocument((File)value, exchange));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Document.class, InputStream.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromInputStreamToDocument((InputStream)value, exchange));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Document.class, String.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromStringToDocument((String)value));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Document.class, Map.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromMapToDocument((Map)value));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, Bson.class, String.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromStringToBson((String)value));
        MongoDbBasicConvertersLoader.addTypeConverter(registry, ObjectId.class, String.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromStringToObjectId((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

