/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.FullDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbChangeStreamsConsumer;
import org.apache.camel.component.mongodb.MongoDbComponent;
import org.apache.camel.component.mongodb.MongoDbConstants;
import org.apache.camel.component.mongodb.MongoDbConsumerType;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.component.mongodb.MongoDbOutputType;
import org.apache.camel.component.mongodb.MongoDbProducer;
import org.apache.camel.component.mongodb.MongoDbTailTrackingConfig;
import org.apache.camel.component.mongodb.MongoDbTailableCursorConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="mongodb", title="MongoDB", syntax="mongodb:connectionBean", category={Category.DATABASE}, headersClass=MongoDbConstants.class)
public class MongoDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbEndpoint.class);
    @UriParam(description="Sets the connection bean used as a client for connecting to a database.")
    private MongoClient mongoConnection;
    @UriPath(description="Sets the connection bean reference used to lookup a client for connecting to a database if no hosts parameter is present.")
    @Metadata(required=true)
    private String connectionBean;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private String hosts;
    @UriParam(label="security")
    private String authSource;
    @UriParam
    private String database;
    @UriParam
    private String collection;
    @UriParam
    private String collectionIndex;
    @UriParam
    private MongoDbOperation operation;
    @UriParam(defaultValue="true")
    private boolean createCollection = true;
    @UriParam(label="advanced")
    private boolean dynamicity;
    @UriParam(label="advanced")
    private boolean writeResultAsHeader;
    @UriParam(label="consumer")
    private String consumerType;
    @UriParam(label="advanced", defaultValue="1000", javaType="java.time.Duration")
    private long cursorRegenerationDelay = 1000L;
    @UriParam(label="consumer,tail")
    private String tailTrackIncreasingField;
    @UriParam(label="consumer,changeStream")
    private String streamFilter;
    @UriParam(label="consumer,changeStream", enums="default,updateLookup,required,whenAvailable", defaultValue="default")
    private FullDocument fullDocument = FullDocument.DEFAULT;
    @UriParam(label="consumer,tail")
    private boolean persistentTailTracking;
    @UriParam(label="consumer,tail")
    private String persistentId;
    @UriParam(label="consumer,tail")
    private String tailTrackDb;
    @UriParam(label="consumer,tail")
    private String tailTrackCollection;
    @UriParam(label="consumer,tail")
    private String tailTrackField;
    @UriParam(label="common")
    private MongoDbOutputType outputType;
    @UriParam(label="advanced", defaultValue="30000")
    private Integer serverSelectionTimeoutMS = 30000;
    @UriParam(label="advanced", defaultValue="15")
    private Integer localThresholdMS = 15;
    @UriParam(label="advanced")
    private Integer heartbeatFrequencyMS;
    @UriParam(label="advanced")
    private String replicaSet;
    @UriParam(label="advanced", defaultValue="false")
    private boolean tls = false;
    @UriParam(label="advanced", defaultValue="false")
    private boolean tlsAllowInvalidHostnames = false;
    @UriParam(label="advanced", defaultValue="10000")
    private Integer connectTimeoutMS = 10000;
    @UriParam(label="advanced", defaultValue="0")
    private Integer socketTimeoutMS = 0;
    @UriParam(label="advanced", defaultValue="0")
    private Integer maxIdleTimeMS = 0;
    @UriParam(label="advanced", defaultValue="0")
    private Integer maxLifeTimeMS = 0;
    @UriParam(label="advanced", defaultValue="0")
    private Integer minPoolSize = 0;
    @UriParam(label="advanced", defaultValue="100")
    private Integer maxPoolSize = 100;
    @UriParam(label="advanced", defaultValue="2")
    private Integer maxConnecting = 2;
    @UriParam(label="advanced", defaultValue="120000")
    private Integer waitQueueTimeoutMS = 120000;
    @UriParam(label="advanced", defaultValue="ACKNOWLEDGED", enums="ACKNOWLEDGED,W1,W2,W3,UNACKNOWLEDGED,JOURNALED,MAJORITY")
    private String writeConcern = "ACKNOWLEDGED";
    @UriParam(label="advanced", defaultValue="PRIMARY", enums="PRIMARY,PRIMARY_PREFERRED,SECONDARY,SECONDARY_PREFERRED,NEAREST")
    private String readPreference = "PRIMARY";
    @UriParam(label="advanced")
    private String readPreferenceTags;
    @UriParam(label="advanced", defaultValue="-1")
    private Integer maxStalenessSeconds = -1;
    @UriParam(label="advanced")
    private String appName;
    @UriParam(label="advanced")
    private String compressors;
    @UriParam(label="advanced")
    private Integer zlibCompressionLevel;
    @UriParam(label="advanced", defaultValue="mongodb")
    private String srvServiceName;
    @UriParam(label="advanced")
    private Integer srvMaxHosts;
    @UriParam(label="advanced", defaultValue="true")
    private boolean retryWrites = true;
    @UriParam(label="advanced", defaultValue="true")
    private boolean retryReads = true;
    @UriParam(label="advanced", defaultValue="false")
    private boolean directConnection = false;
    @UriParam(label="advanced")
    private boolean loadBalanced;
    @UriParam(description="Set the whole Connection String/Uri for mongodb endpoint.", label="additional", defaultValue="null")
    private String connectionUriString;
    private MongoDbConsumerType dbConsumerType;
    private MongoDbTailTrackingConfig tailTrackingConfig;
    private MongoDatabase mongoDatabase;
    private MongoCollection<Document> mongoCollection;

    public MongoDbEndpoint() {
    }

    public MongoDbEndpoint(String uri, MongoDbComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() {
        this.validateProducerOptions();
        this.initializeConnection();
        return new MongoDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validateConsumerOptions();
        this.createCollection = false;
        this.initializeConnection();
        try {
            this.dbConsumerType = ObjectHelper.isEmpty((String)this.consumerType) ? MongoDbConsumerType.tailable : MongoDbConsumerType.valueOf(this.consumerType);
        }
        catch (Exception e) {
            throw new CamelMongoDbException("Consumer type not supported: " + this.consumerType, e);
        }
        DefaultConsumer consumer = switch (this.dbConsumerType) {
            case MongoDbConsumerType.tailable -> new MongoDbTailableCursorConsumer(this, processor);
            case MongoDbConsumerType.changeStreams -> new MongoDbChangeStreamsConsumer(this, processor);
            default -> throw new CamelMongoDbException("Consumer type not supported: " + String.valueOf((Object)this.dbConsumerType));
        };
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private void validateOutputType() {
        if (!ObjectHelper.isEmpty((Object)((Object)this.outputType))) {
            if (MongoDbOutputType.DocumentList.equals((Object)this.outputType) && !MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType DocumentList is only compatible with operation findAll");
            }
            if (MongoDbOutputType.MongoIterable.equals((Object)this.outputType) && !MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType MongoIterable is only compatible with operation findAll");
            }
            if (MongoDbOutputType.Document.equals((Object)this.outputType) && MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType Document is not compatible with operation findAll");
            }
        }
    }

    private void validateProducerOptions() throws IllegalArgumentException {
        if (!(ObjectHelper.isEmpty((Object)((Object)this.dbConsumerType)) && !this.persistentTailTracking && ObjectHelper.isEmpty((String)this.tailTrackDb) && ObjectHelper.isEmpty((String)this.tailTrackCollection) && ObjectHelper.isEmpty((String)this.tailTrackField) && this.cursorRegenerationDelay == 1000L)) {
            throw new IllegalArgumentException("dbConsumerType, tailTracking, cursorRegenerationDelay options cannot appear on a producer endpoint");
        }
    }

    private void validateConsumerOptions() throws IllegalArgumentException {
        if (!ObjectHelper.isEmpty((Object)((Object)this.operation)) || this.dynamicity || this.outputType != null) {
            throw new IllegalArgumentException("operation, dynamicity, outputType options cannot appear on a consumer endpoint");
        }
        if (this.dbConsumerType == MongoDbConsumerType.tailable) {
            if (this.tailTrackIncreasingField == null) {
                throw new IllegalArgumentException("tailTrackIncreasingField option must be set for tailable cursor MongoDB consumer endpoint");
            }
            if (this.persistentTailTracking && ObjectHelper.isEmpty((String)this.persistentId)) {
                throw new IllegalArgumentException("persistentId is compulsory for persistent tail tracking");
            }
        }
    }

    public void initializeConnection() throws CamelMongoDbException {
        LOG.info("Initialising MongoDb endpoint: {}", (Object)this);
        if (this.database == null || this.collection == null && !MongoDbOperation.getDbStats.equals((Object)this.operation) && !MongoDbOperation.command.equals((Object)this.operation)) {
            throw new CamelMongoDbException("Missing required endpoint configuration: database and/or collection");
        }
        if (this.mongoConnection == null) {
            this.mongoConnection = this.resolveMongoConnection();
            if (this.mongoConnection == null) {
                throw new CamelMongoDbException("Could not initialise MongoDbComponent. Could not resolve the mongo connection.");
            }
        }
        this.mongoDatabase = this.mongoConnection.getDatabase(this.database);
        if (this.mongoDatabase == null) {
            throw new CamelMongoDbException("Could not initialise MongoDbComponent. Database " + this.database + " does not exist.");
        }
        if (this.collection != null) {
            if (!this.createCollection && !this.databaseContainsCollection(this.collection)) {
                throw new CamelMongoDbException("Could not initialise MongoDbComponent. Collection " + this.collection + " does not exist on the database and createCollection is false.");
            }
            this.mongoCollection = this.mongoDatabase.getCollection(this.collection, Document.class);
            LOG.debug("MongoDb component initialised and endpoint bound to MongoDB collection with the following parameters. Cluster description: {}, Db: {}, Collection: {}", new Object[]{this.mongoConnection.getClusterDescription(), this.mongoDatabase.getName(), this.collection});
            try {
                if (ObjectHelper.isNotEmpty((String)this.collectionIndex)) {
                    this.ensureIndex(this.mongoCollection, this.createIndex());
                }
            }
            catch (Exception e) {
                throw new CamelMongoDbException("Error creating index", e);
            }
        }
    }

    private boolean databaseContainsCollection(String collectionName) {
        return StreamSupport.stream(this.mongoDatabase.listCollectionNames().spliterator(), false).anyMatch(collectionName::equals);
    }

    public void ensureIndex(MongoCollection<Document> aCollection, List<Bson> dynamicIndex) {
        if (dynamicIndex != null && !dynamicIndex.isEmpty()) {
            for (Bson index : dynamicIndex) {
                LOG.debug("create Document Index {}", (Object)index);
                aCollection.createIndex(index);
            }
        }
    }

    public List<Bson> createIndex() {
        try {
            ArrayList<Bson> indexList = new ArrayList<Bson>();
            if (ObjectHelper.isNotEmpty((String)this.collectionIndex)) {
                HashMap indexMap = (HashMap)new ObjectMapper().readValue(this.collectionIndex, HashMap.class);
                for (Map.Entry set : indexMap.entrySet()) {
                    Document index = new Document();
                    index.put((String)set.getKey(), set.getValue());
                    indexList.add((Bson)index);
                }
            }
            return indexList;
        }
        catch (IOException e) {
            throw new CamelMongoDbException("createIndex failed", e);
        }
    }

    protected void doStart() throws Exception {
        if (this.mongoConnection == null) {
            this.mongoConnection = this.resolveMongoConnection();
        } else {
            LOG.debug("Resolved the connection provided by mongoConnection property parameter as {}", (Object)this.mongoConnection);
        }
        super.doStart();
    }

    private MongoClient resolveMongoConnection() {
        MongoClient mongoClient;
        if (this.hosts != null) {
            Object credentials;
            Object object = credentials = this.username == null ? "" : this.username;
            if (!((String)credentials).isEmpty()) {
                credentials = (String)credentials + (String)(this.password == null ? "@" : ":" + this.password + "@");
            }
            String connectionOptions = this.authSource == null ? "" : "/?authSource=" + this.authSource;
            mongoClient = this.connectionUriString != null ? MongoClients.create((String)this.connectionUriString) : MongoClients.create((String)String.format("mongodb://%s%s%s", credentials, this.hosts, connectionOptions));
            LOG.debug("Connection created using provided credentials");
        } else {
            mongoClient = (MongoClient)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.connectionBean, MongoClient.class);
            LOG.debug("Resolved the connection provided by {} context reference as {}", (Object)this.connectionBean, (Object)this.mongoConnection);
        }
        return mongoClient;
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollectionIndex(String collectionIndex) {
        this.collectionIndex = collectionIndex;
    }

    public String getCollectionIndex() {
        return this.collectionIndex;
    }

    public void setOperation(String operation) throws CamelMongoDbException {
        try {
            this.operation = MongoDbOperation.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Operation not supported", e);
        }
    }

    public void setOperation(MongoDbOperation operation) {
        this.operation = operation;
    }

    public MongoDbOperation getOperation() {
        return this.operation;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setCreateCollection(boolean createCollection) {
        this.createCollection = createCollection;
    }

    public boolean isCreateCollection() {
        return this.createCollection;
    }

    public void setMongoConnection(MongoClient mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    public MongoClient getMongoConnection() {
        return this.mongoConnection;
    }

    public void setDynamicity(boolean dynamicity) {
        this.dynamicity = dynamicity;
    }

    public boolean isDynamicity() {
        return this.dynamicity;
    }

    public void setDbConsumerType(String dbConsumerType) throws CamelMongoDbException {
        try {
            this.dbConsumerType = MongoDbConsumerType.valueOf(dbConsumerType);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Consumer type not supported", e);
        }
    }

    public MongoDbConsumerType getDbConsumerType() {
        return this.dbConsumerType;
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public String getTailTrackDb() {
        return this.tailTrackDb;
    }

    public void setTailTrackDb(String tailTrackDb) {
        this.tailTrackDb = tailTrackDb;
    }

    public String getTailTrackCollection() {
        return this.tailTrackCollection;
    }

    public void setTailTrackCollection(String tailTrackCollection) {
        this.tailTrackCollection = tailTrackCollection;
    }

    public String getTailTrackField() {
        return this.tailTrackField;
    }

    public void setTailTrackField(String tailTrackField) {
        this.tailTrackField = tailTrackField;
    }

    public void setPersistentTailTracking(boolean persistentTailTracking) {
        this.persistentTailTracking = persistentTailTracking;
    }

    public boolean isPersistentTailTracking() {
        return this.persistentTailTracking;
    }

    public void setTailTrackIncreasingField(String tailTrackIncreasingField) {
        this.tailTrackIncreasingField = tailTrackIncreasingField;
    }

    public String getTailTrackIncreasingField() {
        return this.tailTrackIncreasingField;
    }

    public MongoDbTailTrackingConfig getTailTrackingConfig() {
        if (this.tailTrackingConfig == null) {
            this.tailTrackingConfig = new MongoDbTailTrackingConfig(this.persistentTailTracking, this.tailTrackIncreasingField, this.tailTrackDb == null ? this.database : this.tailTrackDb, this.tailTrackCollection, this.tailTrackField, this.getPersistentId());
        }
        return this.tailTrackingConfig;
    }

    public void setCursorRegenerationDelay(long cursorRegenerationDelay) {
        this.cursorRegenerationDelay = cursorRegenerationDelay;
    }

    public long getCursorRegenerationDelay() {
        return this.cursorRegenerationDelay;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public boolean isWriteResultAsHeader() {
        return this.writeResultAsHeader;
    }

    public void setWriteResultAsHeader(boolean writeResultAsHeader) {
        this.writeResultAsHeader = writeResultAsHeader;
    }

    public MongoDbOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(MongoDbOutputType outputType) {
        this.outputType = outputType;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public MongoCollection<Document> getMongoCollection() {
        return this.mongoCollection;
    }

    public String getStreamFilter() {
        return this.streamFilter;
    }

    public void setStreamFilter(String streamFilter) {
        this.streamFilter = streamFilter;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public void setFullDocument(FullDocument fullDocument) {
        this.fullDocument = fullDocument;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public WriteConcern getWriteConcernBean() {
        WriteConcern writeConcernBean = WriteConcern.valueOf((String)this.getWriteConcern());
        if (writeConcernBean == null) {
            throw new IllegalArgumentException(String.format("Unknown WriteConcern configuration %s", this.getWriteConcern()));
        }
        return writeConcernBean;
    }

    public void setReadPreference(String readPreference) {
        this.readPreference = readPreference;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public ReadPreference getReadPreferenceBean() {
        return ReadPreference.valueOf((String)this.getReadPreference());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getAuthSource() {
        return this.authSource;
    }

    public void setAuthSource(String authSource) {
        this.authSource = authSource;
    }

    public void setServerSelectionTimeoutMS(Integer serverSelectionTimeoutMS) {
        this.serverSelectionTimeoutMS = serverSelectionTimeoutMS;
    }

    public Integer getServerSelectionTimeoutMS() {
        return this.serverSelectionTimeoutMS;
    }

    public void setLocalThresholdMS(Integer localThresholdMS) {
        this.localThresholdMS = localThresholdMS;
    }

    public Integer getLocalThresholdMS() {
        return this.localThresholdMS;
    }

    public void setHeartbeatFrequencyMS(Integer heartbeatFrequencyMS) {
        this.heartbeatFrequencyMS = heartbeatFrequencyMS;
    }

    public Integer getHeartbeatFrequencyMS() {
        return this.heartbeatFrequencyMS;
    }

    public void setReplicaSet(String replicaSet) {
        this.replicaSet = replicaSet;
    }

    public String getReplicaSet() {
        return this.replicaSet;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTlsAllowInvalidHostnames(boolean tlsAllowInvalidHostnames) {
        this.tlsAllowInvalidHostnames = tlsAllowInvalidHostnames;
    }

    public boolean isTlsAllowInvalidHostnames() {
        return this.tlsAllowInvalidHostnames;
    }

    public void setConnectTimeoutMS(Integer connectTimeoutMS) {
        this.connectTimeoutMS = connectTimeoutMS;
    }

    public Integer getConnectTimeoutMS() {
        return this.connectTimeoutMS;
    }

    public void setSocketTimeoutMS(Integer socketTimeoutMS) {
        this.socketTimeoutMS = socketTimeoutMS;
    }

    public Integer getSocketTimeoutMS() {
        return this.socketTimeoutMS;
    }

    public void setMaxIdleTimeMS(Integer maxIdleTimeMS) {
        this.maxIdleTimeMS = maxIdleTimeMS;
    }

    public Integer getMaxIdleTimeMS() {
        return this.maxIdleTimeMS;
    }

    public void setMaxLifeTimeMS(Integer maxLifeTimeMS) {
        this.maxLifeTimeMS = maxLifeTimeMS;
    }

    public Integer getMaxLifeTimeMS() {
        return this.maxLifeTimeMS;
    }

    public void setMinPoolSize(Integer minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxConnecting(Integer maxConnecting) {
        this.maxConnecting = maxConnecting;
    }

    public Integer getMaxConnecting() {
        return this.maxConnecting;
    }

    public void setWaitQueueTimeoutMS(Integer waitQueueTimeoutMS) {
        this.waitQueueTimeoutMS = waitQueueTimeoutMS;
    }

    public Integer getWaitQueueTimeoutMS() {
        return this.waitQueueTimeoutMS;
    }

    public void setReadPreferenceTags(String readPreferenceTags) {
        this.readPreferenceTags = readPreferenceTags;
    }

    public String getReadPreferenceTags() {
        return this.readPreferenceTags;
    }

    public void setMaxStalenessSeconds(Integer maxStalenessSeconds) {
        this.maxStalenessSeconds = maxStalenessSeconds;
    }

    public Integer getMaxStalenessSeconds() {
        return this.maxStalenessSeconds;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setCompressors(String compressors) {
        this.compressors = compressors;
    }

    public String getCompressors() {
        return this.compressors;
    }

    public void setZlibCompressionLevel(Integer zlibCompressionLevel) {
        this.zlibCompressionLevel = zlibCompressionLevel;
    }

    public Integer getZlibCompressionLevel() {
        return this.zlibCompressionLevel;
    }

    public void setSrvServiceName(String srvServiceName) {
        this.srvServiceName = srvServiceName;
    }

    public String getSrvServiceName() {
        return this.srvServiceName;
    }

    public void setSrvMaxHosts(Integer srvMaxHosts) {
        this.srvMaxHosts = srvMaxHosts;
    }

    public Integer getSrvMaxHosts() {
        return this.srvMaxHosts;
    }

    public void setRetryWrites(boolean retryWrites) {
        this.retryWrites = retryWrites;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    public void setRetryReads(boolean retryReads) {
        this.retryReads = retryReads;
    }

    public boolean isRetryReads() {
        return this.retryReads;
    }

    public void setDirectConnection(boolean directConnection) {
        this.directConnection = directConnection;
    }

    public boolean isDirectConnection() {
        return this.directConnection;
    }

    public void setLoadBalanced(boolean loadBalanced) {
        this.loadBalanced = loadBalanced;
    }

    public boolean isLoadBalanced() {
        return this.loadBalanced;
    }

    public void setConnectionUriString(String connectionUriString) {
        this.connectionUriString = connectionUriString;
    }

    public String getConnectionUriString() {
        return this.connectionUriString;
    }
}

