/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MyBatisEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":statement";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "mybatis".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "statement", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("onConsume");
        props.add("synchronous");
        props.add("transacted");
        props.add("initialDelay");
        props.add("useIterator");
        props.add("scheduler");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("inputHeader");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("statement");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("executorType");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("routeEmptyResultSet");
        props.add("backoffIdleThreshold");
        props.add("processingStrategy");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("outputHeader");
        props.add("startScheduler");
        props.add("statementType");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

