/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.neo4j.Neo4jSimilarityFunction;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.neo4j.driver.Driver;

@Configurer
@UriParams
public class Neo4jConfiguration
implements Cloneable {
    @Metadata
    @UriParam(description="Url for connecting to Neo database")
    private String databaseUrl;
    @UriParam(label="security", description="Basic authentication database user", displayName="Database user", secret=true)
    private String username;
    @UriParam(label="security", description="Basic authentication database password", displayName="Database password", secret=true)
    private String password;
    @UriParam(label="security", description="Basic authentication database realm", displayName="Database realm", secret=true)
    private String realm;
    @UriParam(label="security", description="Bearer authentication database realm", displayName="Realm", secret=true)
    private String token;
    @UriParam(label="security", description="Kerberos Authentication encoded base64 ticket", displayName="Encoded base64 ticket", secret=true)
    private String kerberosAuthTicket;
    @UriParam
    private String query;
    @UriParam
    private String label;
    @UriParam
    private String vectorIndexName;
    @UriParam
    private String alias;
    @UriParam(defaultValue="false")
    private boolean detachRelationship = false;
    @UriParam
    private Integer dimension;
    @UriParam(defaultValue="cosine")
    private Neo4jSimilarityFunction similarityFunction = Neo4jSimilarityFunction.cosine;
    @UriParam(defaultValue="0.0")
    private double minScore = 0.0;
    @UriParam(defaultValue="3")
    private int maxResults = 3;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private Driver driver;

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isDetachRelationship() {
        return this.detachRelationship;
    }

    public void setDetachRelationship(boolean detachRelationship) {
        this.detachRelationship = detachRelationship;
    }

    public String getVectorIndexName() {
        return this.vectorIndexName;
    }

    public void setVectorIndexName(String vectorIndexName) {
        this.vectorIndexName = vectorIndexName;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public Neo4jSimilarityFunction getSimilarityFunction() {
        return this.similarityFunction;
    }

    public void setSimilarityFunction(Neo4jSimilarityFunction similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public double getMinScore() {
        return this.minScore;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getKerberosAuthTicket() {
        return this.kerberosAuthTicket;
    }

    public void setKerberosAuthTicket(String kerberosAuthTicket) {
        this.kerberosAuthTicket = kerberosAuthTicket;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Neo4jConfiguration copy() {
        try {
            return (Neo4jConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

