/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.neo4j.Neo4jConfiguration;
import org.apache.camel.component.neo4j.Neo4jConstants;
import org.apache.camel.component.neo4j.Neo4jProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;

@UriEndpoint(firstVersion="4.10.0", scheme="neo4j", title="Neo4j", syntax="neo4j:name", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=Neo4jConstants.Headers.class)
public class Neo4jEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @Metadata(required=true)
    @UriPath(description="The database name")
    private final String name;
    @UriParam
    private Neo4jConfiguration configuration;
    private volatile Driver driver;

    public Neo4jEndpoint(String endpointUri, Component component, String name, Neo4jConfiguration configuration) {
        super(endpointUri, component);
        this.name = name;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new Neo4jProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public Neo4jConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceUrl() {
        return null;
    }

    public String getServiceProtocol() {
        return null;
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.driver != null) {
            this.driver = null;
        }
    }

    public Driver getDriver() {
        this.lock.lock();
        try {
            if (this.driver == null) {
                this.driver = this.configuration.getDriver();
                if (this.driver == null) {
                    this.driver = this.createDriver();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.driver;
    }

    private Driver createDriver() {
        String dbUri = this.configuration.getDatabaseUrl();
        ObjectHelper.notNull((Object)dbUri, (String)"dbUri");
        AuthToken authToken = this.createAuthToken();
        ObjectHelper.notNull((Object)authToken, (String)"authentication credentials");
        return GraphDatabase.driver((String)dbUri, (AuthToken)authToken);
    }

    private AuthToken createAuthToken() {
        if (this.configuration.getKerberosAuthTicket() != null) {
            return AuthTokens.kerberos((String)this.configuration.getKerberosAuthTicket());
        }
        if (this.configuration.getToken() != null) {
            return AuthTokens.bearer((String)this.configuration.getToken());
        }
        if (this.configuration.getUsername() != null && this.configuration.getPassword() != null) {
            if (this.configuration.getRealm() != null) {
                return AuthTokens.basic((String)this.configuration.getUsername(), (String)this.configuration.getPassword(), (String)this.configuration.getRealm());
            }
            return AuthTokens.basic((String)this.configuration.getUsername(), (String)this.configuration.getPassword());
        }
        return null;
    }
}

