/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerInitializerFactory;
import org.apache.camel.component.netty.http.NettySharedHttpServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.handlers.HttpInboundStreamHandler;
import org.apache.camel.component.netty.http.handlers.HttpOutboundStreamHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerSharedInitializerFactory
extends HttpServerInitializerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerSharedInitializerFactory.class);
    private final NettySharedHttpServerBootstrapConfiguration configuration;
    private final HttpServerConsumerChannelFactory channelFactory;
    private final CamelContext camelContext;
    private SSLContext sslContext;

    public HttpServerSharedInitializerFactory(NettySharedHttpServerBootstrapConfiguration configuration, HttpServerConsumerChannelFactory channelFactory, CamelContext camelContext) {
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.camelContext = camelContext;
        try {
            this.sslContext = this.createSSLContext();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    @Override
    public ServerInitializerFactory createPipelineFactory(NettyConsumer nettyConsumer) {
        throw new UnsupportedOperationException("Should not call this operation");
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, this.configuration.getMaxHeaderSize(), 8192));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.configuration.isChunked()) {
            pipeline.addLast("inbound-streamer", (ChannelHandler)new HttpInboundStreamHandler());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.configuration.getChunkedMaxContentLength()));
            pipeline.addLast("outbound-streamer", (ChannelHandler)new HttpOutboundStreamHandler());
        }
        if (this.configuration.isCompression()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        }
        pipeline.addLast("handler", this.channelFactory.getChannelHandler());
    }

    private SSLContext createSSLContext() throws Exception {
        SSLContext answer;
        if (!this.configuration.isSsl()) {
            return null;
        }
        if (this.configuration.getSslContextParameters() != null) {
            answer = this.configuration.getSslContextParameters().createSSLContext(null);
        } else {
            char[] pw;
            if (this.configuration.getKeyStoreFile() == null && this.configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (this.configuration.getTrustStoreFile() == null && this.configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (this.configuration.getPassphrase() == null) {
                LOG.debug("passphrase is null");
            }
            char[] cArray = pw = this.configuration.getPassphrase() != null ? this.configuration.getPassphrase().toCharArray() : null;
            if (this.configuration.getKeyStoreFile() != null || this.configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(this.camelContext, this.configuration.getKeyStoreFormat(), this.configuration.getSecurityProvider(), "file:" + this.configuration.getKeyStoreFile().getPath(), "file:" + this.configuration.getTrustStoreFile().getPath(), pw);
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(this.camelContext, this.configuration.getKeyStoreFormat(), this.configuration.getSecurityProvider(), this.configuration.getKeyStoreResource(), this.configuration.getTrustStoreResource(), pw);
            }
        }
        return answer;
    }

    private SslHandler configureServerSSLOnDemand() {
        if (!this.configuration.isSsl()) {
            return null;
        }
        if (this.configuration.getSslHandler() != null) {
            return this.configuration.getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.configuration.isNeedClientAuth());
            if (this.configuration.getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.configuration.getEnabledProtocols().split(","));
            }
            return new SslHandler(engine);
        }
        return null;
    }
}

