/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.http.InboundStreamHttpResponse;
import org.apache.camel.component.netty.http.NettyHttpProducer;

public class HttpClientChannelHandler
extends ClientChannelHandler {
    private final NettyHttpProducer producer;

    public HttpClientChannelHandler(NettyHttpProducer producer) {
        super((NettyProducer)producer);
        this.producer = producer;
    }

    protected Message getResponseMessage(Exchange exchange, ChannelHandlerContext ctx, Object message) throws Exception {
        Message answer;
        FullHttpResponse response;
        if (message instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse;
            response = fullHttpResponse = (FullHttpResponse)message;
            answer = this.producer.getEndpoint().getNettyHttpBinding().toCamelMessage(fullHttpResponse, exchange, this.producer.getConfiguration());
        } else {
            InboundStreamHttpResponse streamHttpResponse = (InboundStreamHttpResponse)message;
            response = streamHttpResponse.getHttpResponse();
            answer = this.producer.getEndpoint().getNettyHttpBinding().toCamelMessage(streamHttpResponse, exchange, this.producer.getConfiguration());
        }
        if (response.status().equals((Object)HttpResponseStatus.CONTINUE)) {
            exchange.setProperty("CamelClientContinue", (Object)true);
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)response)) {
            exchange.setProperty("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        if (this.producer.getEndpoint().getCookieHandler() != null) {
            String actualUri = (String)exchange.getIn().getHeader("CamelHttpUrl", String.class);
            URI uri = new URI(actualUri);
            HashMap<String, List> m = new HashMap<String, List>();
            for (String name : response.headers().names()) {
                m.put(name, response.headers().getAll(name));
            }
            this.producer.getEndpoint().getCookieHandler().storeCookies(exchange, uri, m);
        }
        return answer;
    }
}

