/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpointConfigurer;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class NettyHttpEndpointConfigurer
extends NettyEndpointConfigurer
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NettyHttpEndpoint target = (NettyHttpEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeendpoint": 
            case "bridgeEndpoint": {
                target.getConfiguration().setBridgeEndpoint((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkedmaxcontentlength": 
            case "chunkedMaxContentLength": {
                target.getConfiguration().setChunkedMaxContentLength((Integer)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "compression": {
                target.getConfiguration().setCompression((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((NettyConfiguration)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, NettyHttpConfiguration.class, (Object)value));
                return true;
            }
            case "cookiehandler": 
            case "cookieHandler": {
                target.setCookieHandler((CookieHandler)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, CookieHandler.class, (Object)value));
                return true;
            }
            case "disablestreamcache": 
            case "disableStreamCache": {
                target.getConfiguration().setDisableStreamCache((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "httpmethodrestrict": 
            case "httpMethodRestrict": {
                target.setHttpMethodRestrict((String)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "logwarnonbadrequest": 
            case "logWarnOnBadRequest": {
                target.getConfiguration().setLogWarnOnBadRequest((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mapheaders": 
            case "mapHeaders": {
                target.getConfiguration().setMapHeaders((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "matchonuriprefix": 
            case "matchOnUriPrefix": {
                target.getConfiguration().setMatchOnUriPrefix((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxheadersize": 
            case "maxHeaderSize": {
                target.getConfiguration().setMaxHeaderSize((Integer)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "muteexception": 
            case "muteException": {
                target.getConfiguration().setMuteException((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "nettyhttpbinding": 
            case "nettyHttpBinding": {
                target.setNettyHttpBinding((NettyHttpBinding)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, NettyHttpBinding.class, (Object)value));
                return true;
            }
            case "nettysharedhttpserver": 
            case "nettySharedHttpServer": {
                target.setNettySharedHttpServer((NettySharedHttpServer)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, NettySharedHttpServer.class, (Object)value));
                return true;
            }
            case "okstatuscoderange": 
            case "okStatusCodeRange": {
                target.getConfiguration().setOkStatusCodeRange((String)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityconfiguration": 
            case "securityConfiguration": {
                target.setSecurityConfiguration((NettyHttpSecurityConfiguration)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, NettyHttpSecurityConfiguration.class, (Object)value));
                return true;
            }
            case "securityoptions": 
            case "securityOptions": {
                target.setSecurityOptions((Map)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "send503whensuspended": 
            case "send503whenSuspended": {
                target.getConfiguration().setSend503whenSuspended((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "throwexceptiononfailure": 
            case "throwExceptionOnFailure": {
                target.getConfiguration().setThrowExceptionOnFailure((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "traceenabled": 
            case "traceEnabled": {
                target.setTraceEnabled((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexception": 
            case "transferException": {
                target.getConfiguration().setTransferException((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "urldecodeheaders": 
            case "urlDecodeHeaders": {
                target.getConfiguration().setUrlDecodeHeaders((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "userelativepath": 
            case "useRelativePath": {
                target.getConfiguration().setUseRelativePath((Boolean)NettyHttpEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return super.configure(camelContext, obj, name, value, ignoreCase);
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NettyHttpEndpoint target = (NettyHttpEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeendpoint": 
            case "bridgeEndpoint": {
                return target.getConfiguration().isBridgeEndpoint();
            }
            case "chunkedmaxcontentlength": 
            case "chunkedMaxContentLength": {
                return target.getConfiguration().getChunkedMaxContentLength();
            }
            case "compression": {
                return target.getConfiguration().isCompression();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "cookiehandler": 
            case "cookieHandler": {
                return target.getCookieHandler();
            }
            case "disablestreamcache": 
            case "disableStreamCache": {
                return target.getConfiguration().isDisableStreamCache();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "httpmethodrestrict": 
            case "httpMethodRestrict": {
                return target.getHttpMethodRestrict();
            }
            case "logwarnonbadrequest": 
            case "logWarnOnBadRequest": {
                return target.getConfiguration().isLogWarnOnBadRequest();
            }
            case "mapheaders": 
            case "mapHeaders": {
                return target.getConfiguration().isMapHeaders();
            }
            case "matchonuriprefix": 
            case "matchOnUriPrefix": {
                return target.getConfiguration().isMatchOnUriPrefix();
            }
            case "maxheadersize": 
            case "maxHeaderSize": {
                return target.getConfiguration().getMaxHeaderSize();
            }
            case "muteexception": 
            case "muteException": {
                return target.getConfiguration().isMuteException();
            }
            case "nettyhttpbinding": 
            case "nettyHttpBinding": {
                return target.getNettyHttpBinding();
            }
            case "nettysharedhttpserver": 
            case "nettySharedHttpServer": {
                return target.getNettySharedHttpServer();
            }
            case "okstatuscoderange": 
            case "okStatusCodeRange": {
                return target.getConfiguration().getOkStatusCodeRange();
            }
            case "securityconfiguration": 
            case "securityConfiguration": {
                return target.getSecurityConfiguration();
            }
            case "securityoptions": 
            case "securityOptions": {
                return target.getSecurityOptions();
            }
            case "send503whensuspended": 
            case "send503whenSuspended": {
                return target.getConfiguration().isSend503whenSuspended();
            }
            case "throwexceptiononfailure": 
            case "throwExceptionOnFailure": {
                return target.getConfiguration().isThrowExceptionOnFailure();
            }
            case "traceenabled": 
            case "traceEnabled": {
                return target.isTraceEnabled();
            }
            case "transferexception": 
            case "transferException": {
                return target.getConfiguration().isTransferException();
            }
            case "urldecodeheaders": 
            case "urlDecodeHeaders": {
                return target.getConfiguration().isUrlDecodeHeaders();
            }
            case "userelativepath": 
            case "useRelativePath": {
                return target.getConfiguration().isUseRelativePath();
            }
        }
        return super.getOptionValue(obj, name, ignoreCase);
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("protocol", String.class);
        map.put("host", String.class);
        map.put("port", Integer.TYPE);
        map.put("path", String.class);
        map.put("bridgeEndpoint", Boolean.TYPE);
        map.put("disconnect", Boolean.TYPE);
        map.put("keepAlive", Boolean.TYPE);
        map.put("reuseAddress", Boolean.TYPE);
        map.put("reuseChannel", Boolean.TYPE);
        map.put("sync", Boolean.TYPE);
        map.put("tcpNoDelay", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("matchOnUriPrefix", Boolean.TYPE);
        map.put("muteException", Boolean.TYPE);
        map.put("send503whenSuspended", Boolean.TYPE);
        map.put("backlog", Integer.TYPE);
        map.put("bossCount", Integer.TYPE);
        map.put("bossGroup", EventLoopGroup.class);
        map.put("chunkedMaxContentLength", Integer.TYPE);
        map.put("compression", Boolean.TYPE);
        map.put("disconnectOnNoReply", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("httpMethodRestrict", String.class);
        map.put("logWarnOnBadRequest", Boolean.TYPE);
        map.put("mapHeaders", Boolean.TYPE);
        map.put("maxHeaderSize", Integer.TYPE);
        map.put("nettyServerBootstrapFactory", NettyServerBootstrapFactory.class);
        map.put("nettySharedHttpServer", NettySharedHttpServer.class);
        map.put("noReplyLogLevel", LoggingLevel.class);
        map.put("serverClosedChannelExceptionCaughtLogLevel", LoggingLevel.class);
        map.put("serverExceptionCaughtLogLevel", LoggingLevel.class);
        map.put("serverInitializerFactory", ServerInitializerFactory.class);
        map.put("traceEnabled", Boolean.TYPE);
        map.put("urlDecodeHeaders", Boolean.TYPE);
        map.put("usingExecutorService", Boolean.TYPE);
        map.put("connectTimeout", Integer.TYPE);
        map.put("cookieHandler", CookieHandler.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("requestTimeout", Long.TYPE);
        map.put("throwExceptionOnFailure", Boolean.TYPE);
        map.put("clientInitializerFactory", ClientInitializerFactory.class);
        map.put("lazyChannelCreation", Boolean.TYPE);
        map.put("okStatusCodeRange", String.class);
        map.put("producerPoolEnabled", Boolean.TYPE);
        map.put("producerPoolMaxActive", Integer.TYPE);
        map.put("producerPoolMaxIdle", Integer.TYPE);
        map.put("producerPoolMinEvictableIdle", Long.TYPE);
        map.put("producerPoolMinIdle", Integer.TYPE);
        map.put("useRelativePath", Boolean.TYPE);
        map.put("allowSerializedHeaders", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("channelGroup", ChannelGroup.class);
        map.put("configuration", NettyHttpConfiguration.class);
        map.put("disableStreamCache", Boolean.TYPE);
        map.put("headerFilterStrategy", HeaderFilterStrategy.class);
        map.put("nativeTransport", Boolean.TYPE);
        map.put("nettyHttpBinding", NettyHttpBinding.class);
        map.put("options", Map.class);
        map.put("receiveBufferSize", Integer.TYPE);
        map.put("receiveBufferSizePredictor", Integer.TYPE);
        map.put("sendBufferSize", Integer.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("transferException", Boolean.TYPE);
        map.put("transferExchange", Boolean.TYPE);
        map.put("workerCount", Integer.TYPE);
        map.put("workerGroup", EventLoopGroup.class);
        map.put("decoders", List.class);
        map.put("encoders", List.class);
        map.put("enabledProtocols", String.class);
        map.put("keyStoreFile", File.class);
        map.put("keyStoreFormat", String.class);
        map.put("keyStoreResource", String.class);
        map.put("needClientAuth", Boolean.TYPE);
        map.put("passphrase", String.class);
        map.put("securityConfiguration", NettyHttpSecurityConfiguration.class);
        map.put("securityOptions", Map.class);
        map.put("securityProvider", String.class);
        map.put("ssl", Boolean.TYPE);
        map.put("sslClientCertHeaders", Boolean.TYPE);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("sslHandler", SslHandler.class);
        map.put("trustStoreFile", File.class);
        map.put("trustStoreResource", String.class);
        ALL_OPTIONS = map;
    }
}

