/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NettyHttpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol:host:port/path";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "netty-http".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "path", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(84);
        props.add("usingExecutorService");
        props.add("disconnect");
        props.add("enabledProtocols");
        props.add("synchronous");
        props.add("nettySharedHttpServer");
        props.add("keyStoreFormat");
        props.add("producerPoolMinIdle");
        props.add("ssl");
        props.add("bossGroup");
        props.add("path");
        props.add("protocol");
        props.add("bridgeErrorHandler");
        props.add("securityProvider");
        props.add("useRelativePath");
        props.add("transferException");
        props.add("host");
        props.add("connectTimeout");
        props.add("options");
        props.add("workerGroup");
        props.add("producerPoolMinEvictableIdle");
        props.add("bridgeEndpoint");
        props.add("tcpNoDelay");
        props.add("needClientAuth");
        props.add("sslHandler");
        props.add("logWarnOnBadRequest");
        props.add("throwExceptionOnFailure");
        props.add("encoders");
        props.add("keyStoreFile");
        props.add("decoders");
        props.add("reuseAddress");
        props.add("sync");
        props.add("securityOptions");
        props.add("workerCount");
        props.add("lazyStartProducer");
        props.add("backlog");
        props.add("disableStreamCache");
        props.add("port");
        props.add("passphrase");
        props.add("compression");
        props.add("nettyServerBootstrapFactory");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("securityConfiguration");
        props.add("basicPropertyBinding");
        props.add("trustStoreResource");
        props.add("bossCount");
        props.add("serverInitializerFactory");
        props.add("sslClientCertHeaders");
        props.add("configuration");
        props.add("disconnectOnNoReply");
        props.add("sslContextParameters");
        props.add("keyStoreResource");
        props.add("maxHeaderSize");
        props.add("reuseChannel");
        props.add("producerPoolMaxIdle");
        props.add("producerPoolEnabled");
        props.add("trustStoreFile");
        props.add("chunkedMaxContentLength");
        props.add("headerFilterStrategy");
        props.add("noReplyLogLevel");
        props.add("urlDecodeHeaders");
        props.add("transferExchange");
        props.add("mapHeaders");
        props.add("requestTimeout");
        props.add("muteException");
        props.add("receiveBufferSizePredictor");
        props.add("keepAlive");
        props.add("producerPoolMaxActive");
        props.add("nettyHttpBinding");
        props.add("httpMethodRestrict");
        props.add("matchOnUriPrefix");
        props.add("clientInitializerFactory");
        props.add("sendBufferSize");
        props.add("exchangePattern");
        props.add("lazyChannelCreation");
        props.add("allowSerializedHeaders");
        props.add("channelGroup");
        props.add("okStatusCodeRange");
        props.add("send503whenSuspended");
        props.add("receiveBufferSize");
        props.add("serverClosedChannelExceptionCaughtLogLevel");
        props.add("nativeTransport");
        props.add("serverExceptionCaughtLogLevel");
        props.add("traceEnabled");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("passphrase");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

