/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ChannelHandlerFactories;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfiguration
implements Cloneable {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyConfiguration.class);
    private String protocol;
    private String host;
    private int port;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private boolean broadcast;
    private long connectTimeout = 10000L;
    private boolean reuseAddress = true;
    private boolean sync = true;
    private boolean textline;
    private TextLineDelimiter delimiter = TextLineDelimiter.LINE;
    private boolean autoAppendDelimiter = true;
    private int decoderMaxLineLength = 1024;
    private String encoding;
    private String passphrase;
    private File keyStoreFile;
    private File trustStoreFile;
    private SslHandler sslHandler;
    private List<ChannelHandler> encoders = new ArrayList<ChannelHandler>();
    private List<ChannelHandler> decoders = new ArrayList<ChannelHandler>();
    private boolean ssl;
    private long sendBufferSize = 65536L;
    private long receiveBufferSize = 65536L;
    private int receiveBufferSizePredictor;
    private int workerCount;
    private String keyStoreFormat;
    private String securityProvider;
    private boolean disconnect;
    private boolean lazyChannelCreation = true;
    private boolean transferExchange;
    private boolean disconnectOnNoReply = true;
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    private boolean allowDefaultCodec = true;
    private ClientPipelineFactory clientPipelineFactory;
    private ServerPipelineFactory serverPipelineFactory;
    private SSLContextParameters sslContextParameters;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            ArrayList<ChannelHandler> encodersCopy = new ArrayList<ChannelHandler>(this.encoders);
            answer.setEncoders(encodersCopy);
            ArrayList<ChannelHandler> decodersCopy = new ArrayList<ChannelHandler>(this.decoders);
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void validateConfiguration() {
        for (ChannelHandler encoder : this.encoders) {
            if (encoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)encoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The encoder {} is not @Shareable or an ChannelHandlerFactory instance. The encoder cannot safely be used.", (Object)encoder);
        }
        for (ChannelHandler decoder : this.decoders) {
            if (decoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)decoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The decoder {} is not @Shareable or an ChannelHandlerFactory instance. The decoder cannot safely be used.", (Object)decoder);
        }
        if (this.sslHandler != null) {
            boolean shareable;
            boolean factory = this.sslHandler instanceof ChannelHandlerFactory;
            boolean bl = shareable = ObjectHelper.getAnnotation((Object)this.sslHandler, ChannelHandler.Sharable.class) != null;
            if (!factory && !shareable) {
                LOG.warn("The sslHandler {} is not @Shareable or an ChannelHandlerFactory instance. The sslHandler cannot safely be used.", (Object)this.sslHandler);
            }
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component) throws Exception {
        this.protocol = uri.getScheme();
        if (!this.protocol.equalsIgnoreCase("tcp") && !this.protocol.equalsIgnoreCase("udp")) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.sslHandler = (SslHandler)component.resolveAndRemoveReferenceParameter(parameters, "sslHandler", SslHandler.class, null);
        this.passphrase = (String)component.resolveAndRemoveReferenceParameter(parameters, "passphrase", String.class, null);
        this.keyStoreFormat = (String)component.getAndRemoveParameter(parameters, "keyStoreFormat", String.class, "JKS");
        this.securityProvider = (String)component.getAndRemoveParameter(parameters, "securityProvider", String.class, "SunX509");
        this.keyStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "keyStoreFile", File.class, null);
        this.trustStoreFile = (File)component.resolveAndRemoveReferenceParameter(parameters, "trustStoreFile", File.class, null);
        this.clientPipelineFactory = (ClientPipelineFactory)component.resolveAndRemoveReferenceParameter(parameters, "clientPipelineFactory", ClientPipelineFactory.class, null);
        this.serverPipelineFactory = (ServerPipelineFactory)component.resolveAndRemoveReferenceParameter(parameters, "serverPipelineFactory", ServerPipelineFactory.class, null);
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.encoders, referencedEncoders, ChannelHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.decoders, referencedDecoders, ChannelHandler.class);
        EndpointHelper.setReferenceProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        EndpointHelper.setProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        if (this.encoders.isEmpty() && this.decoders.isEmpty()) {
            if (this.allowDefaultCodec) {
                if (this.isTextline()) {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encoders.add(ChannelHandlerFactories.newStringEncoder(charset));
                    ChannelBuffer[] delimiters = this.delimiter == TextLineDelimiter.LINE ? Delimiters.lineDelimiter() : Delimiters.nulDelimiter();
                    this.decoders.add(ChannelHandlerFactories.newDelimiterBasedFrameDecoder(this.decoderMaxLineLength, delimiters));
                    this.decoders.add(ChannelHandlerFactories.newStringDecoder(charset));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using textline encoders and decoders with charset: {}, delimiter: {} and decoderMaxLineLength: {}", new Object[]{charset, this.delimiter, this.decoderMaxLineLength});
                    }
                } else {
                    this.encoders.add(ChannelHandlerFactories.newObjectEncoder());
                    this.decoders.add(ChannelHandlerFactories.newObjectDecoder());
                    LOG.debug("Using object encoders and decoders");
                }
            } else {
                LOG.debug("No encoders and decoders will be used");
            }
        } else {
            LOG.debug("Using configured encoders and/or decoders");
        }
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public boolean isTcp() {
        return this.protocol.equalsIgnoreCase("tcp");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public TextLineDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(TextLineDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isAutoAppendDelimiter() {
        return this.autoAppendDelimiter;
    }

    public void setAutoAppendDelimiter(boolean autoAppendDelimiter) {
        this.autoAppendDelimiter = autoAppendDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public List<ChannelHandler> getDecoders() {
        return this.decoders;
    }

    public void setDecoders(List<ChannelHandler> decoders) {
        this.decoders = decoders;
    }

    public List<ChannelHandler> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(List<ChannelHandler> encoders) {
        this.encoders = encoders;
    }

    public ChannelHandler getEncoder() {
        return this.encoders.isEmpty() ? null : this.encoders.get(0);
    }

    public void setEncoder(ChannelHandler encoder) {
        if (!this.encoders.contains(encoder)) {
            this.encoders.add(encoder);
        }
    }

    public ChannelHandler getDecoder() {
        return this.decoders.isEmpty() ? null : this.decoders.get(0);
    }

    public void setDecoder(ChannelHandler decoder) {
        if (!this.decoders.contains(decoder)) {
            this.decoders.add(decoder);
        }
    }

    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(long sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(long receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSizePredictor() {
        return this.receiveBufferSizePredictor;
    }

    public void setReceiveBufferSizePredictor(int receiveBufferSizePredictor) {
        this.receiveBufferSizePredictor = receiveBufferSizePredictor;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    public void setClientPipelineFactory(ClientPipelineFactory clientPipelineFactory) {
        this.clientPipelineFactory = clientPipelineFactory;
    }

    public ClientPipelineFactory getClientPipelineFactory() {
        return this.clientPipelineFactory;
    }

    public void setServerPipelineFactory(ServerPipelineFactory serverPipelineFactory) {
        this.serverPipelineFactory = serverPipelineFactory;
    }

    public ServerPipelineFactory getServerPipelineFactory() {
        return this.serverPipelineFactory;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    private static <T> void addToHandlersList(List<T> configured, List<T> handlers, Class<T> handlerType) {
        if (handlers != null) {
            for (int x = 0; x < handlers.size(); ++x) {
                T handler = handlers.get(x);
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }
}

