/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.netty.DefaultServerPipelineFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private final ChannelGroup allChannels;
    private CamelContext context = this.getEndpoint().getCamelContext();
    private NettyConfiguration configuration;
    private ChannelFactory channelFactory;
    private DatagramChannelFactory datagramChannelFactory;
    private ServerBootstrap serverBootstrap;
    private ConnectionlessBootstrap connectionlessServerBootstrap;
    private ServerPipelineFactory pipelineFactory;
    private Channel channel;
    private ExecutorService bossExecutor;
    private ExecutorService workerExecutor;

    public NettyConsumer(NettyEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint, processor);
        this.configuration = configuration;
        this.allChannels = new DefaultChannelGroup("NettyConsumer-" + nettyEndpoint.getEndpointUri());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Netty consumer binding to: {}", (Object)this.configuration.getAddress());
        ServerPipelineFactory factory = this.configuration.getServerPipelineFactory();
        this.pipelineFactory = factory != null ? factory.createPipelineFactory(this) : new DefaultServerPipelineFactory(this);
        if (this.isTcp()) {
            this.initializeTCPServerSocketCommunicationLayer();
        } else {
            this.initializeUDPServerSocketCommunicationLayer();
        }
        LOG.info("Netty consumer bound to: " + this.configuration.getAddress());
    }

    protected void doStop() throws Exception {
        LOG.debug("Netty consumer unbinding from: {}", (Object)this.configuration.getAddress());
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.bossExecutor != null) {
            this.context.getExecutorServiceManager().shutdownNow(this.bossExecutor);
        }
        if (this.workerExecutor != null) {
            this.context.getExecutorServiceManager().shutdownNow(this.workerExecutor);
        }
        LOG.info("Netty consumer unbound from: " + this.configuration.getAddress());
        super.doStop();
    }

    public CamelContext getContext() {
        return this.context;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public DatagramChannelFactory getDatagramChannelFactory() {
        return this.datagramChannelFactory;
    }

    public void setDatagramChannelFactory(DatagramChannelFactory datagramChannelFactory) {
        this.datagramChannelFactory = datagramChannelFactory;
    }

    public ServerBootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public void setServerBootstrap(ServerBootstrap serverBootstrap) {
        this.serverBootstrap = serverBootstrap;
    }

    public ConnectionlessBootstrap getConnectionlessServerBootstrap() {
        return this.connectionlessServerBootstrap;
    }

    public void setConnectionlessServerBootstrap(ConnectionlessBootstrap connectionlessServerBootstrap) {
        this.connectionlessServerBootstrap = connectionlessServerBootstrap;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }

    private void initializeTCPServerSocketCommunicationLayer() throws Exception {
        this.bossExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyTCPBoss");
        this.workerExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyTCPWorker");
        this.channelFactory = this.configuration.getWorkerCount() <= 0 ? new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor) : new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor, this.configuration.getWorkerCount());
        this.serverBootstrap = new ServerBootstrap(this.channelFactory);
        this.serverBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.serverBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        this.channel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.allChannels.add((Object)this.channel);
    }

    private void initializeUDPServerSocketCommunicationLayer() throws Exception {
        this.workerExecutor = this.context.getExecutorServiceManager().newCachedThreadPool((Object)this, "NettyUDPWorker");
        this.datagramChannelFactory = this.configuration.getWorkerCount() <= 0 ? new NioDatagramChannelFactory((Executor)this.workerExecutor) : new NioDatagramChannelFactory((Executor)this.workerExecutor, this.configuration.getWorkerCount());
        this.connectionlessServerBootstrap = new ConnectionlessBootstrap((ChannelFactory)this.datagramChannelFactory);
        this.connectionlessServerBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.connectionlessServerBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.connectionlessServerBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
        this.connectionlessServerBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.connectionlessServerBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        this.connectionlessServerBootstrap.setOption("child.broadcast", (Object)this.configuration.isBroadcast());
        this.connectionlessServerBootstrap.setOption("sendBufferSize", (Object)this.configuration.getSendBufferSize());
        this.connectionlessServerBootstrap.setOption("receiveBufferSize", (Object)this.configuration.getReceiveBufferSize());
        if (this.configuration.getReceiveBufferSizePredictor() > 0) {
            this.connectionlessServerBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(this.configuration.getReceiveBufferSizePredictor()));
        }
        this.connectionlessServerBootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        this.channel = this.connectionlessServerBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.allChannels.add((Object)this.channel);
    }
}

