/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.Timer;

public class NettyEndpoint
extends DefaultEndpoint {
    private NettyConfiguration configuration;
    private Timer timer;

    public NettyEndpoint(String endpointUri, NettyComponent component, NettyConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new NettyConsumer(this, processor, this.configuration);
    }

    public Producer createProducer() throws Exception {
        NettyProducer answer = new NettyProducer(this, this.configuration);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Exchange createExchange(ChannelHandlerContext ctx, MessageEvent messageEvent) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setHeader("CamelNettyChannelHandlerContext", (Object)ctx);
        exchange.getIn().setHeader("CamelNettyMessageEvent", (Object)messageEvent);
        exchange.getIn().setHeader("CamelNettyRemoteAddress", (Object)messageEvent.getRemoteAddress());
        NettyPayloadHelper.setIn(exchange, messageEvent.getMessage());
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.timer, (String)"timer");
    }
}

