/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.netty.NettyCamelState;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.util.ExchangeHelper;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private final NettyProducer producer;
    private volatile boolean messageReceived;
    private volatile boolean exceptionHandled;

    public ClientChannelHandler(NettyProducer producer) {
        this.producer = producer;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelStateEvent) throws Exception {
        this.producer.getAllChannels().add((Object)channelStateEvent.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exception caught at Channel: " + ctx.getChannel(), exceptionEvent.getCause());
        }
        if (this.exceptionHandled) {
            return;
        }
        this.exceptionHandled = true;
        Throwable cause = exceptionEvent.getCause();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel as an exception was thrown from Netty", cause);
        }
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        if (exchange != null && callback != null) {
            exchange.setException(cause);
            NettyHelper.close(exceptionEvent.getChannel());
            callback.done(false);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.trace("Channel closed: {}", (Object)ctx.getChannel());
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        this.producer.removeState(ctx.getChannel());
        if (this.producer.getConfiguration().isSync() && !this.messageReceived && !this.exceptionHandled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel closed but no message received from address: {}", (Object)this.producer.getConfiguration().getAddress());
            }
            exchange.setException((Throwable)new CamelExchangeException("No response received from remote server: " + this.producer.getConfiguration().getAddress(), exchange));
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        this.messageReceived = true;
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        Object body = messageEvent.getMessage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", new Object[]{messageEvent.getChannel(), body});
        }
        if (this.producer.getConfiguration().isTextline()) {
            try {
                body = this.producer.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
            }
            catch (NoTypeConversionAvailableException e) {
                exchange.setException((Throwable)e);
                callback.done(false);
            }
        }
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            NettyPayloadHelper.setOut(exchange, body);
        } else {
            NettyPayloadHelper.setIn(exchange, body);
        }
        try {
            Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
            boolean disconnect = this.producer.getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel when complete at address: {}", (Object)this.producer.getConfiguration().getAddress());
                }
                NettyHelper.close(ctx.getChannel());
            }
        }
        finally {
            callback.done(false);
        }
    }

    private Exchange getExchange(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.getChannel());
        return state != null ? state.getExchange() : null;
    }

    private AsyncCallback getAsyncCallback(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.getChannel());
        return state != null ? state.getCallback() : null;
    }
}

