/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.NettyServerBossPoolBuilder;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.support.ServiceSupport;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTCPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(SingleTCPNettyServerBootstrapFactory.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup(SingleTCPNettyServerBootstrapFactory.class.getName());
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelPipelineFactory pipelineFactory;
    private ChannelFactory channelFactory;
    private ServerBootstrap serverBootstrap;
    private Channel channel;
    private BossPool bossPool;
    private WorkerPool workerPool;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void addChannel(Channel channel) {
        this.allChannels.add((Object)channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.allChannels.remove((Object)channel);
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void doResume() throws Exception {
        if (this.channel != null) {
            LOG.debug("ServerBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ChannelFuture future = this.channel.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            future.awaitUninterruptibly();
            if (!future.isSuccess()) {
                this.allChannels.remove((Object)this.channel);
                this.channel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
                this.allChannels.add((Object)this.channel);
            }
        }
    }

    protected void doSuspend() throws Exception {
        if (this.channel != null) {
            LOG.debug("ServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ChannelFuture future = this.channel.unbind();
            future.awaitUninterruptibly();
        }
    }

    protected void startServerBootstrap() {
        BossPool bp = this.configuration.getBossPool();
        WorkerPool wp = this.configuration.getWorkerPool();
        if (bp == null) {
            bp = this.bossPool = new NettyServerBossPoolBuilder().withBossCount(this.configuration.getBossCount()).withName("NettyServerTCPBoss").build();
        }
        if (wp == null) {
            wp = this.workerPool = new NettyWorkerPoolBuilder().withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        this.channelFactory = new NioServerSocketChannelFactory(bp, wp);
        this.serverBootstrap = new ServerBootstrap(this.channelFactory);
        this.serverBootstrap.setOption("child.keepAlive", (Object)this.configuration.isKeepAlive());
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.serverBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("child.reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("child.connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        if (this.configuration.getBacklog() > 0) {
            this.serverBootstrap.setOption("backlog", (Object)this.configuration.getBacklog());
        }
        if (this.configuration.getOptions() != null) {
            for (Map.Entry<String, Object> entry : this.configuration.getOptions().entrySet()) {
                this.serverBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        LOG.debug("Created ServerBootstrap {} with options: {}", (Object)this.serverBootstrap, (Object)this.serverBootstrap.getOptions());
        this.serverBootstrap.setPipelineFactory(this.pipelineFactory);
        LOG.info("ServerBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        this.channel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.allChannels.add((Object)this.channel);
    }

    protected void stopServerBootstrap() {
        LOG.info("ServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
            this.channelFactory = null;
        }
        if (this.bossPool != null) {
            this.bossPool.shutdown();
            this.bossPool = null;
        }
        if (this.workerPool != null) {
            this.workerPool.shutdown();
            this.workerPool = null;
        }
    }
}

