/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty.codec.ObjectEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DatagramPacketObjectEncoder
extends MessageToMessageEncoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramPacketObjectEncoder.class);
    private ObjectEncoder delegateObjectEncoder = new ObjectEncoder();

    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof Serializable) {
            Serializable payload = (Serializable)msg.content();
            ByteBuf buf = ctx.alloc().buffer();
            this.delegateObjectEncoder.encode(ctx, payload, buf);
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)buf, msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        } else {
            LOG.debug("Ignoring message content as it is not a java.io.Serializable instance.");
        }
    }
}

