/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.component.netty.util.SubnetUtils;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUDPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(SingleUDPNettyServerBootstrapFactory.class);
    private static final String LOOPBACK_INTERFACE = "lo";
    private static final String MULTICAST_SUBNET = "224.0.0.0/4";
    private final ChannelGroup allChannels = new DefaultChannelGroup(SingleUDPNettyServerBootstrapFactory.class.getName(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelInitializer<Channel> pipelineFactory;
    private NetworkInterface multicastNetworkInterface;
    private Channel channel;
    private EventLoopGroup workerGroup;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void addChannel(Channel channel) {
        this.allChannels.add((Object)channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.allChannels.remove((Object)channel);
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void startServerBootstrap() throws Exception {
        Map<String, Object> options;
        EventLoopGroup wg = this.configuration.getWorkerGroup();
        if (wg == null) {
            wg = this.workerGroup = new NettyWorkerPoolBuilder().withNativeTransport(this.configuration.isNativeTransport()).withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        Bootstrap bootstrap = new Bootstrap();
        if (this.configuration.isNativeTransport()) {
            ((Bootstrap)bootstrap.group(wg)).channel(EpollDatagramChannel.class);
        } else {
            ((Bootstrap)bootstrap.group(wg)).channel(NioDatagramChannel.class);
        }
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.configuration.isReuseAddress());
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.configuration.getSendBufferSize());
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.configuration.getReceiveBufferSize());
        bootstrap.option(ChannelOption.SO_BROADCAST, (Object)this.configuration.isBroadcast());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectTimeout());
        if (this.configuration.getReceiveBufferSizePredictor() > 0) {
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.configuration.getReceiveBufferSizePredictor()));
        }
        if (this.configuration.getBacklog() > 0) {
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.configuration.getBacklog());
        }
        if ((options = this.configuration.getOptions()) != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                String value = entry.getValue().toString();
                ChannelOption option = ChannelOption.valueOf((String)entry.getKey());
                if (EndpointHelper.isReferenceParameter((String)value)) {
                    String name = value.substring(1);
                    Object o = CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)name);
                    bootstrap.option(option, o);
                    continue;
                }
                bootstrap.option(option, (Object)value);
            }
        }
        LOG.debug("Created Bootstrap {}", (Object)bootstrap);
        bootstrap.handler(this.pipelineFactory);
        InetSocketAddress hostAddress = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        SubnetUtils multicastSubnet = new SubnetUtils(MULTICAST_SUBNET);
        if (multicastSubnet.getInfo().isInRange(this.configuration.getHost())) {
            channelFuture = bootstrap.bind(this.configuration.getPort()).sync();
            this.channel = channelFuture.channel();
            DatagramChannel datagramChannel = (DatagramChannel)this.channel;
            String networkInterface = this.configuration.getNetworkInterface() == null ? LOOPBACK_INTERFACE : this.configuration.getNetworkInterface();
            this.multicastNetworkInterface = NetworkInterface.getByName(networkInterface);
            ObjectHelper.notNull((Object)this.multicastNetworkInterface, (String)("No network interface found for '" + networkInterface + "'."));
            LOG.info("ConnectionlessBootstrap joining {}:{} using network interface: {}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), this.multicastNetworkInterface.getName()});
            datagramChannel.joinGroup(hostAddress, this.multicastNetworkInterface).syncUninterruptibly();
            this.allChannels.add((Object)datagramChannel);
        } else {
            LOG.info("ConnectionlessBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            channelFuture = bootstrap.bind((SocketAddress)hostAddress).sync();
            this.channel = channelFuture.channel();
            this.allChannels.add((Object)this.channel);
        }
    }

    protected void stopServerBootstrap() {
        LOG.info("ConnectionlessBootstrap disconnecting from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        this.allChannels.close().awaitUninterruptibly();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

