/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.http.NettyHttpHeaderFilterStrategy;

public class NettyHttpRestHeaderFilterStrategy
extends NettyHttpHeaderFilterStrategy {
    private final String templateUri;
    private final String queryParameters;

    public NettyHttpRestHeaderFilterStrategy(String templateUri, String queryParameters) {
        this.templateUri = templateUri;
        this.queryParameters = queryParameters;
    }

    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
        boolean answer = super.applyFilterToExternalHeaders(headerName, headerValue, exchange);
        if (!answer) {
            String token;
            if (this.templateUri != null && this.templateUri.contains(token = "{" + headerName + "}")) {
                answer = true;
            }
            if (!answer && this.queryParameters != null && this.queryParameters.contains(token = "=%7B" + headerName + "%7D")) {
                answer = true;
            }
        }
        return answer;
    }
}

