/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.concurrent.CamelThreadFactory;

@Component(value="netty,netty4")
public class NettyComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private NettyConfiguration configuration;
    @Metadata(label="advanced", defaultValue="16")
    private int maximumPoolSize = 16;
    @Metadata(label="advanced")
    private volatile EventExecutorGroup executorService;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public NettyComponent() {
    }

    public NettyComponent(Class<? extends Endpoint> endpointClass) {
    }

    public NettyComponent(CamelContext context) {
        super(context);
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HashMap options;
        NettyConfiguration config = this.configuration != null ? this.configuration.copy() : new NettyConfiguration();
        config = this.parseConfiguration(config, remaining, parameters);
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null && IntrospectionSupport.getProperties((Object)bootstrapConfiguration, options = new HashMap(), null, (boolean)false)) {
            IntrospectionSupport.setProperties((TypeConverter)this.getCamelContext().getTypeConverter(), (Object)config, options);
        }
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        config.validateConfiguration();
        NettyEndpoint nettyEndpoint = new NettyEndpoint(remaining, this, config);
        this.setProperties(nettyEndpoint.getConfiguration(), parameters);
        return nettyEndpoint;
    }

    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(new URI(remaining), parameters, this, "tcp", "udp");
        return configuration;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setExecutorService(EventExecutorGroup executorService) {
        this.executorService = executorService;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    @Metadata(description="To configure security using SSLContextParameters", label="security")
    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        if (this.configuration == null) {
            this.configuration = new NettyConfiguration();
        }
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public EventExecutorGroup getExecutorService() {
        return this.executorService;
    }

    protected void doStart() throws Exception {
        if (this.configuration == null) {
            this.configuration = new NettyConfiguration();
        }
        if (this.configuration.isUsingExecutorService() && this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        super.doStart();
    }

    protected EventExecutorGroup createExecutorService() {
        String pattern = this.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        CamelThreadFactory factory = new CamelThreadFactory(pattern, "NettyEventExecutorGroup", true);
        return new DefaultEventExecutorGroup(this.getMaximumPoolSize(), (ThreadFactory)factory);
    }

    protected void doStop() throws Exception {
        if (this.configuration.isUsingExecutorService() && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
        if (this.configuration.getWorkerGroup() != null) {
            this.configuration.getWorkerGroup().shutdownGracefully();
        }
        super.doStop();
    }
}

