/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import com.github.brainlag.nsq.NSQConfig;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.nsq.NsqComponent;
import org.apache.camel.component.nsq.NsqConfiguration;
import org.apache.camel.component.nsq.NsqConsumer;
import org.apache.camel.component.nsq.NsqProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.23.0", scheme="nsq", title="NSQ", syntax="nsq:lookupServer", consumerClass=NsqConsumer.class, label="messaging")
public class NsqEndpoint
extends DefaultEndpoint {
    @UriParam
    private NsqConfiguration configuration;

    public NsqEndpoint(String uri, NsqComponent component, NsqConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new NsqProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTopic())) {
            throw new RuntimeCamelException("Missing required endpoint configuration: topic must be defined for NSQ consumer");
        }
        return new NsqConsumer(this, processor);
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "NsqTopic[" + this.configuration.getTopic() + "]", this.configuration.getPoolSize());
    }

    public boolean isSingleton() {
        return true;
    }

    public NsqConfiguration getNsqConfiguration() {
        return this.configuration;
    }

    public NSQConfig getNsqConfig() throws GeneralSecurityException, IOException {
        NSQConfig nsqConfig = new NSQConfig();
        if (this.getNsqConfiguration().getSslContextParameters() != null && this.getNsqConfiguration().isSecure()) {
            JdkSslContext sslContext = new JdkSslContext(this.getNsqConfiguration().getSslContextParameters().createSSLContext(this.getCamelContext()), true, null);
            nsqConfig.setSslContext((SslContext)sslContext);
        }
        if (this.configuration.getUserAgent() != null && !this.configuration.getUserAgent().isEmpty()) {
            nsqConfig.setUserAgent(this.configuration.getUserAgent());
        }
        if (this.configuration.getMessageTimeout() > -1L) {
            nsqConfig.setMsgTimeout(Integer.valueOf((int)this.configuration.getMessageTimeout()));
        }
        return nsqConfig;
    }
}

