/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.nsq.NsqConfiguration;
import org.apache.camel.component.nsq.NsqEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;

public class NsqComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NsqConfiguration configuration = new NsqConfiguration();
        this.setProperties(configuration, parameters);
        configuration.setServers(remaining);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        NsqEndpoint endpoint = new NsqEndpoint(uri, this, configuration);
        return endpoint;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

