/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import com.github.brainlag.nsq.lookup.NSQLookup;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.nsq.NsqEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class NsqEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NsqEndpoint target = (NsqEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autofinish": 
            case "autoFinish": {
                target.getConfiguration().setAutoFinish((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "channel": {
                target.getConfiguration().setChannel((String)NsqEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customnsqlookup": 
            case "customNSQLookup": {
                target.getConfiguration().setCustomNSQLookup((NSQLookup)NsqEndpointConfigurer.property((CamelContext)camelContext, NSQLookup.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)NsqEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)NsqEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lookupinterval": 
            case "lookupInterval": {
                target.getConfiguration().setLookupInterval(((Duration)NsqEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "lookupserverport": 
            case "lookupServerPort": {
                target.getConfiguration().setLookupServerPort((Integer)NsqEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messagetimeout": 
            case "messageTimeout": {
                target.getConfiguration().setMessageTimeout(((Duration)NsqEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "poolsize": 
            case "poolSize": {
                target.getConfiguration().setPoolSize((Integer)NsqEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "port": {
                target.getConfiguration().setPort((Integer)NsqEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "requeueinterval": 
            case "requeueInterval": {
                target.getConfiguration().setRequeueInterval(((Duration)NsqEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "secure": {
                target.getConfiguration().setSecure((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "servers": {
                target.getConfiguration().setServers((String)NsqEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters((SSLContextParameters)NsqEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)NsqEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useragent": 
            case "userAgent": {
                target.getConfiguration().setUserAgent((String)NsqEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NsqEndpoint target = (NsqEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autofinish": 
            case "autoFinish": {
                return target.getConfiguration().getAutoFinish();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "channel": {
                return target.getConfiguration().getChannel();
            }
            case "customnsqlookup": 
            case "customNSQLookup": {
                return target.getConfiguration().getCustomNSQLookup();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "lookupinterval": 
            case "lookupInterval": {
                return target.getConfiguration().getLookupInterval();
            }
            case "lookupserverport": 
            case "lookupServerPort": {
                return target.getConfiguration().getLookupServerPort();
            }
            case "messagetimeout": 
            case "messageTimeout": {
                return target.getConfiguration().getMessageTimeout();
            }
            case "poolsize": 
            case "poolSize": {
                return target.getConfiguration().getPoolSize();
            }
            case "port": {
                return target.getConfiguration().getPort();
            }
            case "requeueinterval": 
            case "requeueInterval": {
                return target.getConfiguration().getRequeueInterval();
            }
            case "secure": {
                return target.getConfiguration().isSecure();
            }
            case "servers": {
                return target.getConfiguration().getServers();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "useragent": 
            case "userAgent": {
                return target.getConfiguration().getUserAgent();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("topic", String.class);
        map.put("servers", String.class);
        map.put("userAgent", String.class);
        map.put("autoFinish", Boolean.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("channel", String.class);
        map.put("customNSQLookup", NSQLookup.class);
        map.put("lookupInterval", Long.TYPE);
        map.put("lookupServerPort", Integer.TYPE);
        map.put("messageTimeout", Long.TYPE);
        map.put("poolSize", Integer.TYPE);
        map.put("requeueInterval", Long.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("port", Integer.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("secure", Boolean.TYPE);
        map.put("sslContextParameters", SSLContextParameters.class);
        ALL_OPTIONS = map;
    }
}

