/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ognl;

import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.language.ognl.CamelClassResolver;
import org.apache.camel.language.ognl.OgnlExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LanguageSupport;

@Language(value="ognl")
public class OgnlLanguage
extends LanguageSupport
implements ScriptingLanguage {
    public Predicate createPredicate(String expression) {
        expression = this.loadResource(expression);
        return new OgnlExpression(expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new OgnlExpression(expression, Object.class);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        try {
            Object compiled = Ognl.parseExpression((String)script);
            OgnlContext oglContext = new OgnlContext();
            if (bindings != null && !bindings.isEmpty()) {
                oglContext.setValues(bindings);
            }
            oglContext.setClassResolver((ClassResolver)new CamelClassResolver(this.getCamelContext().getClassResolver()));
            Object value = Ognl.getValue((Object)compiled, (Object)oglContext);
            return (T)this.getCamelContext().getTypeConverter().convertTo(resultType, value);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(script, (Throwable)e);
        }
    }
}

