/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4.api.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.serialization.ODataReader;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;

public abstract class AbstractFutureCallback<T>
implements FutureCallback<HttpResponse> {
    public static final Pattern ODATA_MIME_TYPE_PATTERN = Pattern.compile("application/((atom)|(json)|(xml)).*");
    public static final int NETWORK_CONNECT_TIMEOUT_ERROR = 599;
    private final Olingo4ResponseHandler<T> responseHandler;

    AbstractFutureCallback(Olingo4ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
    }

    public static HttpStatusCode checkStatus(HttpResponse response) throws ODataException, ODataClientErrorException {
        StatusLine statusLine = response.getStatusLine();
        HttpStatusCode httpStatusCode = HttpStatusCode.fromStatusCode((int)statusLine.getStatusCode());
        if (HttpStatusCode.BAD_REQUEST.getStatusCode() <= httpStatusCode.getStatusCode() && httpStatusCode.getStatusCode() <= 599) {
            if (response.getEntity() != null) {
                try {
                    ContentType responseContentType = ContentType.parse((String)response.getFirstHeader("Content-Type").getValue());
                    if (ODATA_MIME_TYPE_PATTERN.matcher(responseContentType.toContentTypeString()).matches()) {
                        ODataReader reader = ODataClientFactory.getClient().getReader();
                        ODataError error = reader.readError(response.getEntity().getContent(), responseContentType);
                        throw new ODataClientErrorException(statusLine, error);
                    }
                }
                catch (IOException e) {
                    throw new ODataException(e.getMessage(), (Throwable)e);
                }
            }
            throw new ODataException(statusLine.getReasonPhrase());
        }
        return httpStatusCode;
    }

    public final void completed(HttpResponse result) {
        try {
            AbstractFutureCallback.checkStatus(result);
            this.onCompleted(result);
        }
        catch (Exception e) {
            this.failed(e);
        }
        finally {
            if (result instanceof Closeable) {
                try {
                    ((Closeable)result).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void onCompleted(HttpResponse var1) throws ODataException, IOException;

    public final void failed(Exception ex) {
        this.responseHandler.onException(ex);
    }

    public final void cancelled() {
        this.responseHandler.onCanceled();
    }
}

