/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4.api.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.component.olingo4.api.Olingo4App;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchChangeRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchQueryRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchResponse;
import org.apache.camel.component.olingo4.api.batch.Operation;
import org.apache.camel.component.olingo4.api.impl.AbstractFutureCallback;
import org.apache.camel.component.olingo4.api.impl.Olingo4Helper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.serialization.ODataReader;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchController;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchLineIteratorImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.http.HttpMerge;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public final class Olingo4AppImpl
implements Olingo4App {
    private static final String SEPARATOR = "/";
    private static final String BOUNDARY_PREFIX = "batch_";
    private static final String BOUNDARY_PARAMETER = "; boundary=";
    private static final String BOUNDARY_DOUBLE_DASH = "--";
    private static final String MULTIPART_MIME_TYPE = "multipart/";
    private static final String CONTENT_ID_HEADER = "Content-ID";
    private static final String CLIENT_ENTITY_FAKE_MARKER = "('X')";
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String)"charset", (String)"UTF-8");
    private static final ContentType METADATA_CONTENT_TYPE = ContentType.create((ContentType)ContentType.APPLICATION_XML, (String)"charset", (String)"UTF-8");
    private static final ContentType TEXT_PLAIN_WITH_CS_UTF_8 = ContentType.create((ContentType)ContentType.TEXT_PLAIN, (String)"charset", (String)"UTF-8");
    private static final ContentType SERVICE_DOCUMENT_CONTENT_TYPE = ContentType.APPLICATION_JSON;
    private static final ContentType BATCH_CONTENT_TYPE = ContentType.MULTIPART_MIXED;
    private final Closeable client;
    private final ODataClient odataClient = ODataClientFactory.getClient();
    private final ODataReader odataReader = this.odataClient.getReader();
    private final ODataWriter odataWriter = this.odataClient.getWriter();
    private String serviceUri;
    private ContentType contentType;
    private Map<String, String> httpHeaders;

    public Olingo4AppImpl(String serviceUri) {
        this(serviceUri, (HttpClientBuilder)null);
    }

    public Olingo4AppImpl(String serviceUri, HttpAsyncClientBuilder builder) {
        this.setServiceUri(serviceUri);
        CloseableHttpAsyncClient asyncClient = builder == null ? HttpAsyncClients.createDefault() : builder.build();
        asyncClient.start();
        this.client = asyncClient;
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    public Olingo4AppImpl(String serviceUri, HttpClientBuilder builder) {
        this.setServiceUri(serviceUri);
        this.client = builder == null ? HttpClients.createDefault() : builder.build();
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    @Override
    public void setServiceUri(String serviceUri) {
        if (serviceUri == null || serviceUri.isEmpty()) {
            throw new IllegalArgumentException("serviceUri");
        }
        this.serviceUri = serviceUri.endsWith(SEPARATOR) ? serviceUri.substring(0, serviceUri.length() - 1) : serviceUri;
    }

    @Override
    public String getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Override
    public String getContentType() {
        return this.contentType.toContentTypeString();
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = ContentType.parse((String)contentType);
    }

    @Override
    public void close() {
    }

    @Override
    public <T> void read(Edm edm, String resourcePath, Map<String, String> queryParams, final Olingo4ResponseHandler<T> responseHandler) {
        String queryOptions = this.concatQueryParams(queryParams);
        final UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, queryOptions);
        this.execute((HttpUriRequest)new HttpGet(this.createUri(resourcePath, queryOptions)), this.getResourceContentType(uriInfo), new AbstractFutureCallback<T>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                Olingo4AppImpl.this.readContent(uriInfo, result.getEntity() != null ? result.getEntity().getContent() : null, responseHandler);
            }
        });
    }

    @Override
    public void uread(Edm edm, String resourcePath, Map<String, String> queryParams, final Olingo4ResponseHandler<InputStream> responseHandler) {
        String queryOptions = this.concatQueryParams(queryParams);
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, queryOptions);
        this.execute((HttpUriRequest)new HttpGet(this.createUri(resourcePath, queryOptions)), this.getResourceContentType(uriInfo), new AbstractFutureCallback<InputStream>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                InputStream responseStream;
                InputStream inputStream = responseStream = result.getEntity() != null ? result.getEntity().getContent() : null;
                if (responseStream != null && result.getEntity() instanceof DecompressingEntity) {
                    responseHandler.onResponse(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)responseStream)));
                } else {
                    responseHandler.onResponse(responseStream);
                }
            }
        });
    }

    @Override
    public <T> void create(Edm edm, String resourcePath, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPost(this.createUri(resourcePath, null)), uriInfo, data, responseHandler);
    }

    @Override
    public <T> void update(Edm edm, String resourcePath, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPut(this.createUri(resourcePath, null)), uriInfo, data, responseHandler);
    }

    @Override
    public void delete(String resourcePath, final Olingo4ResponseHandler<HttpStatusCode> responseHandler) {
        this.execute((HttpUriRequest)new HttpDelete(this.createUri(resourcePath)), this.contentType, new AbstractFutureCallback<HttpStatusCode>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) {
                StatusLine statusLine = result.getStatusLine();
                responseHandler.onResponse(HttpStatusCode.fromStatusCode((int)statusLine.getStatusCode()));
            }
        });
    }

    @Override
    public <T> void patch(Edm edm, String resourcePath, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPatch(this.createUri(resourcePath, null)), uriInfo, data, responseHandler);
    }

    @Override
    public <T> void merge(Edm edm, String resourcePath, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpMerge(this.createUri(resourcePath, null)), uriInfo, data, responseHandler);
    }

    @Override
    public void batch(Edm edm, Object data, Olingo4ResponseHandler<List<Olingo4BatchResponse>> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, SegmentType.BATCH.getValue(), null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPost(this.createUri(SegmentType.BATCH.getValue(), null)), uriInfo, data, responseHandler);
    }

    private ContentType getResourceContentType(UriInfo uriInfo) {
        ContentType resourceContentType;
        switch (uriInfo.getKind()) {
            case service: {
                resourceContentType = SERVICE_DOCUMENT_CONTENT_TYPE;
                break;
            }
            case metadata: {
                resourceContentType = METADATA_CONTENT_TYPE;
                break;
            }
            case resource: {
                List listResource = uriInfo.getUriResourceParts();
                UriResourceKind lastResourceKind = ((UriResource)listResource.get(listResource.size() - 1)).getKind();
                if (lastResourceKind == UriResourceKind.count || lastResourceKind == UriResourceKind.value) {
                    resourceContentType = TEXT_PLAIN_WITH_CS_UTF_8;
                    break;
                }
                resourceContentType = this.contentType;
                break;
            }
            default: {
                resourceContentType = this.contentType;
            }
        }
        return resourceContentType;
    }

    private <T> void readContent(UriInfo uriInfo, InputStream content, Olingo4ResponseHandler<T> responseHandler) {
        try {
            responseHandler.onResponse(this.readContent(uriInfo, content));
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException((Exception)new ODataException("Runtime Error Occurred", (Throwable)e));
        }
    }

    private <T> T readContent(UriInfo uriInfo, InputStream content) throws ODataException {
        Object response = null;
        block2 : switch (uriInfo.getKind()) {
            case service: {
                response = this.odataReader.readServiceDocument(content, SERVICE_DOCUMENT_CONTENT_TYPE);
                break;
            }
            case metadata: {
                response = this.odataReader.readMetadata(content);
                break;
            }
            case resource: {
                List listResource = uriInfo.getUriResourceParts();
                UriResourceKind lastResourceKind = ((UriResource)listResource.get(listResource.size() - 1)).getKind();
                switch (lastResourceKind) {
                    case entitySet: {
                        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)listResource.get(listResource.size() - 1);
                        List keyPredicates = uriResourceEntitySet.getKeyPredicates();
                        if (keyPredicates.size() == 1) {
                            response = this.odataReader.readEntity(content, this.getResourceContentType(uriInfo));
                            break block2;
                        }
                        response = this.odataReader.readEntitySet(content, this.getResourceContentType(uriInfo));
                        break block2;
                    }
                    case count: {
                        String stringCount = null;
                        try {
                            stringCount = IOUtils.toString((InputStream)content, (Charset)Consts.UTF_8);
                            response = Long.valueOf(stringCount);
                            break block2;
                        }
                        catch (IOException e) {
                            throw new ODataException("Error during $count value deserialization", (Throwable)e);
                        }
                        catch (NumberFormatException e) {
                            throw new ODataException("Error during $count value conversion: " + stringCount, (Throwable)e);
                        }
                    }
                    case value: {
                        try {
                            ClientPrimitiveValue value = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(EdmPrimitiveTypeKind.String).setValue((Object)IOUtils.toString((InputStream)content, (Charset)Consts.UTF_8)).build();
                            response = value;
                            break block2;
                        }
                        catch (IOException e) {
                            throw new ODataException("Error during $value deserialization", (Throwable)e);
                        }
                    }
                    case primitiveProperty: 
                    case complexProperty: {
                        ClientProperty property = this.odataReader.readProperty(content, this.getResourceContentType(uriInfo));
                        if (property.hasPrimitiveValue()) {
                            response = property.getPrimitiveValue();
                            break block2;
                        }
                        if (property.hasComplexValue()) {
                            response = property.getComplexValue();
                            break block2;
                        }
                        throw new ODataException("Unsupported property: " + property.getName());
                    }
                    case function: {
                        UriResourceFunctionImpl uriResourceFunction = (UriResourceFunctionImpl)listResource.get(listResource.size() - 1);
                        EdmReturnType functionReturnType = uriResourceFunction.getFunction().getReturnType();
                        switch (functionReturnType.getType().getKind()) {
                            case ENTITY: {
                                if (functionReturnType.isCollection()) {
                                    response = this.odataReader.readEntitySet(content, this.getResourceContentType(uriInfo));
                                    break block2;
                                }
                                response = this.odataReader.readEntity(content, this.getResourceContentType(uriInfo));
                                break block2;
                            }
                            case PRIMITIVE: 
                            case COMPLEX: {
                                ClientProperty functionProperty = this.odataReader.readProperty(content, this.getResourceContentType(uriInfo));
                                if (functionProperty.hasPrimitiveValue()) {
                                    response = functionProperty.getPrimitiveValue();
                                    break block2;
                                }
                                if (functionProperty.hasComplexValue()) {
                                    response = functionProperty.getComplexValue();
                                    break block2;
                                }
                                throw new ODataException("Unsupported property: " + functionProperty.getName());
                            }
                        }
                        throw new ODataException("Unsupported function return type " + uriInfo.getKind().name());
                    }
                }
                throw new ODataException("Unsupported resource type: " + lastResourceKind.name());
            }
            default: {
                throw new ODataException("Unsupported resource type " + uriInfo.getKind().name());
            }
        }
        return (T)response;
    }

    private <T> void writeContent(final Edm edm, HttpEntityEnclosingRequestBase httpEntityRequest, final UriInfo uriInfo, final Object content, final Olingo4ResponseHandler<T> responseHandler) {
        try {
            httpEntityRequest.setEntity((HttpEntity)this.writeContent(edm, uriInfo, content));
            Header requestContentTypeHeader = httpEntityRequest.getEntity().getContentType();
            ContentType requestContentType = requestContentTypeHeader != null ? ContentType.parse((String)requestContentTypeHeader.getValue()) : this.contentType;
            this.execute((HttpUriRequest)httpEntityRequest, requestContentType, new AbstractFutureCallback<T>(responseHandler){

                @Override
                public void onCompleted(HttpResponse result) throws IOException, ODataException {
                    boolean noEntity;
                    HttpStatusCode statusCode = HttpStatusCode.fromStatusCode((int)result.getStatusLine().getStatusCode());
                    boolean bl = noEntity = result.getEntity() == null || result.getEntity().getContentLength() == 0L;
                    if (statusCode == HttpStatusCode.NO_CONTENT || noEntity) {
                        responseHandler.onResponse(HttpStatusCode.fromStatusCode((int)result.getStatusLine().getStatusCode()));
                    } else if (uriInfo.getKind() == UriInfoKind.resource) {
                        List listResource = uriInfo.getUriResourceParts();
                        UriResourceKind lastResourceKind = ((UriResource)listResource.get(listResource.size() - 1)).getKind();
                        switch (lastResourceKind) {
                            case entitySet: {
                                if (content instanceof ClientEntity) {
                                    ClientEntity entity = Olingo4AppImpl.this.odataReader.readEntity(result.getEntity().getContent(), ContentType.parse((String)result.getEntity().getContentType().getValue()));
                                    responseHandler.onResponse(entity);
                                    break;
                                }
                                throw new ODataException("Unsupported content type: " + content);
                            }
                        }
                    } else if (uriInfo.getKind() == UriInfoKind.batch) {
                        List batchResponse = Olingo4AppImpl.this.parseBatchResponse(edm, result, (List)content);
                        responseHandler.onResponse(batchResponse);
                    } else {
                        throw new ODataException("Unsupported resource type: " + uriInfo.getKind().name());
                    }
                }
            });
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException((Exception)new ODataException("Runtime Error Occurred", (Throwable)e));
        }
    }

    private AbstractHttpEntity writeContent(Edm edm, UriInfo uriInfo, Object content) throws ODataException {
        InputStream requestStream = null;
        ByteArrayEntity httpEntity = null;
        if (uriInfo.getKind() == UriInfoKind.resource) {
            List listResource = uriInfo.getUriResourceParts();
            UriResourceKind lastResourceKind = ((UriResource)listResource.get(listResource.size() - 1)).getKind();
            switch (lastResourceKind) {
                case entitySet: {
                    if (content instanceof ClientEntity) {
                        requestStream = this.odataWriter.writeEntity((ClientEntity)content, this.getResourceContentType(uriInfo));
                        break;
                    }
                    throw new ODataException("Unsupported content type: " + content);
                }
                default: {
                    throw new ODataException("Unsupported resource type: " + lastResourceKind);
                }
            }
            try {
                httpEntity = new ByteArrayEntity(IOUtils.toByteArray((InputStream)requestStream));
            }
            catch (IOException e) {
                throw new ODataException("Error during converting input stream to byte array", (Throwable)e);
            }
            httpEntity.setChunked(false);
        } else if (uriInfo.getKind() == UriInfoKind.batch) {
            String boundary = BOUNDARY_PREFIX + UUID.randomUUID();
            String contentHeader = BATCH_CONTENT_TYPE + BOUNDARY_PARAMETER + boundary;
            List batchParts = (List)content;
            requestStream = this.serializeBatchRequest(edm, batchParts, BOUNDARY_DOUBLE_DASH + boundary);
            try {
                httpEntity = new ByteArrayEntity(IOUtils.toByteArray((InputStream)requestStream));
            }
            catch (IOException e) {
                throw new ODataException("Error during converting input stream to byte array", (Throwable)e);
            }
            httpEntity.setChunked(false);
            httpEntity.setContentType(contentHeader);
        } else {
            throw new ODataException("Unsupported resource type: " + uriInfo.getKind().name());
        }
        return httpEntity;
    }

    private InputStream serializeBatchRequest(Edm edm, List<Olingo4BatchRequest> batchParts, String boundary) throws ODataException {
        ByteArrayOutputStream batchRequestHeaderOutputStream = new ByteArrayOutputStream();
        try {
            batchRequestHeaderOutputStream.write(boundary.getBytes("UTF-8"));
            batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
            for (Olingo4BatchRequest batchPart : batchParts) {
                String acceptCharset;
                ContentType acceptType;
                UriInfo uriInfo;
                this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Type", ContentType.APPLICATION_HTTP.toContentTypeString());
                this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Transfer-Encoding: binary", null);
                if (batchPart instanceof Olingo4BatchQueryRequest) {
                    Olingo4BatchQueryRequest batchQueryPart = (Olingo4BatchQueryRequest)batchPart;
                    String batchQueryUri = this.createUri(StringUtils.isBlank((CharSequence)batchQueryPart.getResourceUri()) ? this.serviceUri : batchQueryPart.getResourceUri(), batchQueryPart.getResourcePath(), this.concatQueryParams(batchQueryPart.getQueryParams()));
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchQueryPart.getResourcePath(), this.concatQueryParams(batchQueryPart.getQueryParams()));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write(("GET " + batchQueryUri + " " + HttpVersion.HTTP_1_1).getBytes("UTF-8"));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    acceptType = this.getResourceContentType(uriInfo);
                    acceptCharset = acceptType.getParameter("charset");
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept", acceptType.getType().toLowerCase());
                    if (null != acceptCharset) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept-Charset", acceptCharset.toLowerCase());
                    }
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write(boundary.getBytes("UTF-8"));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    continue;
                }
                if (batchPart instanceof Olingo4BatchChangeRequest) {
                    Olingo4BatchChangeRequest batchChangePart = (Olingo4BatchChangeRequest)batchPart;
                    String batchChangeUri = this.createUri(StringUtils.isBlank((CharSequence)batchChangePart.getResourceUri()) ? this.serviceUri : batchChangePart.getResourceUri(), batchChangePart.getResourcePath(), null);
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchChangePart.getResourcePath(), null);
                    if (batchChangePart.getOperation() != Operation.DELETE) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, CONTENT_ID_HEADER, batchChangePart.getContentId());
                    }
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write((batchChangePart.getOperation().getHttpMethod() + " " + batchChangeUri + " " + HttpVersion.HTTP_1_1).getBytes("UTF-8"));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "OData-Version", ODataServiceVersion.V40.toString());
                    acceptType = this.getResourceContentType(uriInfo);
                    acceptCharset = acceptType.getParameter("charset");
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept", acceptType.getType().toLowerCase());
                    if (null != acceptCharset) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept-Charset", acceptCharset.toLowerCase());
                    }
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Type", acceptType.toContentTypeString());
                    if (batchChangePart.getOperation() != Operation.DELETE) {
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                        AbstractHttpEntity httpEnity = this.writeContent(edm, uriInfo, batchChangePart.getBody());
                        batchRequestHeaderOutputStream.write(IOUtils.toByteArray((InputStream)httpEnity.getContent()));
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    } else {
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    }
                    batchRequestHeaderOutputStream.write(boundary.getBytes("UTF-8"));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    continue;
                }
                throw new ODataException("Unsupported batch part request object type: " + batchPart);
            }
        }
        catch (Exception e) {
            throw new ODataException("Error during batch request serialization", (Throwable)e);
        }
        return new ByteArrayInputStream(batchRequestHeaderOutputStream.toByteArray());
    }

    private void writeHttpHeader(ByteArrayOutputStream headerOutputStream, String headerName, String headerValue) throws IOException {
        headerOutputStream.write(this.createHttpHeader(headerName, headerValue).getBytes("UTF-8"));
        headerOutputStream.write(ODataStreamer.CRLF);
    }

    private String createHttpHeader(String headerName, String headerValue) {
        return headerName + (StringUtils.isBlank((CharSequence)headerValue) ? "" : ": " + headerValue);
    }

    private List<Olingo4BatchResponse> parseBatchResponse(Edm edm, HttpResponse response, List<Olingo4BatchRequest> batchRequest) throws ODataException {
        ArrayList<Olingo4BatchResponse> batchResponse = new ArrayList<Olingo4BatchResponse>();
        try {
            Header[] contentHeaders = response.getHeaders("Content-Type");
            ODataBatchLineIteratorImpl batchLineIterator = new ODataBatchLineIteratorImpl(IOUtils.lineIterator((InputStream)response.getEntity().getContent(), (String)"UTF-8"));
            String batchBoundary = ODataBatchUtilities.getBoundaryFromHeader(this.getHeadersCollection(contentHeaders));
            ODataBatchController batchController = new ODataBatchController((ODataBatchLineIterator)batchLineIterator, batchBoundary);
            batchController.getBatchLineIterator().next();
            int batchRequestIndex = 0;
            while (batchController.getBatchLineIterator().hasNext()) {
                UriInfo uriInfo;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ODataBatchUtilities.readBatchPart((ODataBatchController)batchController, (OutputStream)os, (boolean)false);
                Object content = null;
                Olingo4BatchRequest batchPartRequest = batchRequest.get(batchRequestIndex);
                HttpResponse batchPartHttpResponse = this.constructBatchPartHttpResponse(new ByteArrayInputStream(os.toByteArray()));
                StatusLine batchPartStatusLine = batchPartHttpResponse.getStatusLine();
                int batchPartLineStatusCode = batchPartStatusLine.getStatusCode();
                Map<String, String> batchPartHeaders = this.getHeadersValueMap(batchPartHttpResponse.getAllHeaders());
                if (batchPartRequest instanceof Olingo4BatchQueryRequest) {
                    Olingo4BatchQueryRequest batchPartQueryRequest = (Olingo4BatchQueryRequest)batchPartRequest;
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchPartQueryRequest.getResourcePath(), null);
                    if (HttpStatusCode.BAD_REQUEST.getStatusCode() <= batchPartLineStatusCode && batchPartLineStatusCode <= 599) {
                        ContentType responseContentType = Olingo4Helper.getContentTypeHeader(batchPartHttpResponse);
                        content = this.odataReader.readError(batchPartHttpResponse.getEntity().getContent(), responseContentType);
                    } else if (batchPartLineStatusCode != HttpStatusCode.NO_CONTENT.getStatusCode()) {
                        content = this.readContent(uriInfo, batchPartHttpResponse.getEntity().getContent());
                    }
                    Olingo4BatchResponse batchPartResponse = new Olingo4BatchResponse(batchPartStatusLine.getStatusCode(), batchPartStatusLine.getReasonPhrase(), null, batchPartHeaders, content);
                    batchResponse.add(batchPartResponse);
                } else if (batchPartRequest instanceof Olingo4BatchChangeRequest) {
                    Olingo4BatchChangeRequest batchPartChangeRequest = (Olingo4BatchChangeRequest)batchPartRequest;
                    if (batchPartLineStatusCode != HttpStatusCode.NO_CONTENT.getStatusCode()) {
                        if (HttpStatusCode.BAD_REQUEST.getStatusCode() <= batchPartLineStatusCode && batchPartLineStatusCode <= 599) {
                            ContentType responseContentType = ContentType.parse((String)batchPartHttpResponse.getFirstHeader("Content-Type").getValue());
                            content = this.odataReader.readError(response.getEntity().getContent(), responseContentType);
                        } else {
                            uriInfo = Olingo4AppImpl.parseUri(edm, batchPartChangeRequest.getResourcePath() + (batchPartChangeRequest.getOperation() == Operation.CREATE ? CLIENT_ENTITY_FAKE_MARKER : ""), null);
                            content = this.readContent(uriInfo, batchPartHttpResponse.getEntity().getContent());
                        }
                    }
                    Olingo4BatchResponse batchPartResponse = new Olingo4BatchResponse(batchPartStatusLine.getStatusCode(), batchPartStatusLine.getReasonPhrase(), batchPartChangeRequest.getContentId(), batchPartHeaders, content);
                    batchResponse.add(batchPartResponse);
                } else {
                    throw new ODataException("Unsupported batch part request object type: " + batchPartRequest);
                }
                ++batchRequestIndex;
            }
        }
        catch (IOException | HttpException e) {
            throw new ODataException(e);
        }
        return batchResponse;
    }

    private HttpResponse constructBatchPartHttpResponse(InputStream batchPartStream) throws IOException, HttpException {
        LineIterator lines = IOUtils.lineIterator((InputStream)batchPartStream, (String)"UTF-8");
        ByteArrayOutputStream headerOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        boolean startBatchPartHeader = false;
        boolean startBatchPartBody = false;
        while (lines.hasNext()) {
            String line = lines.nextLine().trim();
            if (line.startsWith("HTTP")) {
                startBatchPartHeader = true;
            }
            if (startBatchPartHeader && StringUtils.isBlank((CharSequence)line)) {
                startBatchPartHeader = false;
                startBatchPartBody = true;
            }
            if (startBatchPartHeader) {
                headerOutputStream.write(line.getBytes("UTF-8"));
                headerOutputStream.write(ODataStreamer.CRLF);
                continue;
            }
            if (!startBatchPartBody || !StringUtils.isNotBlank((CharSequence)line)) continue;
            bodyOutputStream.write(line.getBytes("UTF-8"));
            bodyOutputStream.write(ODataStreamer.CRLF);
        }
        HttpTransportMetricsImpl metrics = new HttpTransportMetricsImpl();
        SessionInputBufferImpl sessionInputBuffer = new SessionInputBufferImpl(metrics, 2048);
        DefaultHttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
        sessionInputBuffer.bind((InputStream)new ByteArrayInputStream(headerOutputStream.toByteArray()));
        DefaultHttpResponseParser responseParser = new DefaultHttpResponseParser((SessionInputBuffer)sessionInputBuffer, (LineParser)new BasicLineParser(), (HttpResponseFactory)responseFactory, MessageConstraints.DEFAULT);
        HttpResponse response = (HttpResponse)responseParser.parse();
        response.setEntity((HttpEntity)new ByteArrayEntity(bodyOutputStream.toByteArray()));
        return response;
    }

    private Collection<String> getHeadersCollection(Header[] headers) {
        ArrayList<String> headersCollection = new ArrayList<String>();
        for (Header header : Arrays.asList(headers)) {
            headersCollection.add(header.getValue());
        }
        return headersCollection;
    }

    private Map<String, String> getHeadersValueMap(Header[] headers) {
        HashMap<String, String> headersValueMap = new HashMap<String, String>();
        for (Header header : Arrays.asList(headers)) {
            headersValueMap.put(header.getName(), header.getValue());
        }
        return headersValueMap;
    }

    private String createUri(String resourcePath) {
        return this.createUri(this.serviceUri, resourcePath, null);
    }

    private String createUri(String resourcePath, String queryOptions) {
        return this.createUri(this.serviceUri, resourcePath, queryOptions);
    }

    private String createUri(String resourceUri, String resourcePath, String queryOptions) {
        StringBuilder absolutUri = new StringBuilder(resourceUri).append(SEPARATOR).append(resourcePath);
        if (queryOptions != null && !queryOptions.isEmpty()) {
            absolutUri.append("/?" + queryOptions);
        }
        return absolutUri.toString();
    }

    private String concatQueryParams(Map<String, String> queryParams) {
        StringBuilder concatQuery = new StringBuilder("");
        if (queryParams != null && !queryParams.isEmpty()) {
            int nParams = queryParams.size();
            int index = 0;
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                concatQuery.append(entry.getKey()).append('=').append(entry.getValue());
                if (++index >= nParams) continue;
                concatQuery.append('&');
            }
        }
        return concatQuery.toString().replaceAll("  *", "%20");
    }

    private static UriInfo parseUri(Edm edm, String resourcePath, String queryOptions) {
        UriInfo result;
        Parser parser = new Parser(edm, OData.newInstance());
        try {
            result = parser.parseUri(resourcePath, queryOptions, null);
        }
        catch (UriParserException | UriValidationException e) {
            throw new IllegalArgumentException("parseUri (" + resourcePath + "," + queryOptions + "): " + e.getMessage(), e);
        }
        return result;
    }

    public void execute(HttpUriRequest httpUriRequest, ContentType contentType, FutureCallback<HttpResponse> callback) {
        if (!ContentType.APPLICATION_FORM_URLENCODED.equals((Object)contentType) && !contentType.toContentTypeString().startsWith(MULTIPART_MIME_TYPE)) {
            httpUriRequest.addHeader("Accept", contentType.getType().toLowerCase());
            String acceptCharset = contentType.getParameter("charset");
            if (null != acceptCharset) {
                httpUriRequest.addHeader("Accept-Charset", acceptCharset.toLowerCase());
            }
        }
        if (httpUriRequest instanceof HttpEntityEnclosingRequestBase && httpUriRequest.getFirstHeader("Content-Type") == null) {
            httpUriRequest.addHeader("Content-Type", contentType.toString());
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            for (Map.Entry entry : this.httpHeaders.entrySet()) {
                httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!httpUriRequest.containsHeader("Accept-Charset")) {
            httpUriRequest.addHeader("Accept-Charset", "UTF-8".toLowerCase());
        }
        if (!httpUriRequest.containsHeader("OData-Version")) {
            httpUriRequest.addHeader("OData-Version", ODataServiceVersion.V40.toString());
        }
        if (!httpUriRequest.containsHeader("OData-MaxVersion")) {
            httpUriRequest.addHeader("OData-MaxVersion", ODataServiceVersion.V40.toString());
        }
        if (this.client instanceof CloseableHttpAsyncClient) {
            ((CloseableHttpAsyncClient)this.client).execute(httpUriRequest, callback);
        } else {
            try {
                CloseableHttpResponse result = ((CloseableHttpClient)this.client).execute(httpUriRequest);
                callback.completed((Object)result);
            }
            catch (IOException e) {
                callback.failed((Exception)e);
            }
        }
    }
}

