/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.concurrent.CountDownLatch;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo4.api.Olingo4App;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.olingo.commons.api.edm.Edm;

public class Olingo4AppWrapper {
    private final Olingo4App olingo4App;
    private volatile Edm edm;

    public Olingo4AppWrapper(Olingo4App olingo4App) {
        ObjectHelper.notNull((Object)olingo4App, (String)"olingo4App");
        this.olingo4App = olingo4App;
    }

    public Olingo4App getOlingo4App() {
        return this.olingo4App;
    }

    public void close() {
        this.olingo4App.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edm getEdm() throws RuntimeCamelException {
        Edm localEdm = this.edm;
        if (localEdm == null) {
            Olingo4AppWrapper olingo4AppWrapper = this;
            synchronized (olingo4AppWrapper) {
                localEdm = this.edm;
                if (localEdm == null) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    final Exception[] error = new Exception[1];
                    this.olingo4App.read(null, "$metadata", null, (Olingo4ResponseHandler)new Olingo4ResponseHandler<Edm>(){

                        public void onResponse(Edm response) {
                            Olingo4AppWrapper.this.edm = response;
                            latch.countDown();
                        }

                        public void onException(Exception ex) {
                            error[0] = ex;
                            latch.countDown();
                        }

                        public void onCanceled() {
                            error[0] = new RuntimeCamelException("OData HTTP request cancelled!");
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                        Exception ex = error[0];
                        if (ex != null) {
                            if (ex instanceof RuntimeCamelException) {
                                throw (RuntimeCamelException)ex;
                            }
                            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
                            throw new RuntimeCamelException("Error reading EDM: " + message, (Throwable)ex);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeCamelException(e.getMessage(), (Throwable)e);
                    }
                    localEdm = this.edm;
                }
            }
        }
        return localEdm;
    }
}

