/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.olingo4.Olingo4AppWrapper;
import org.apache.camel.component.olingo4.Olingo4Component;
import org.apache.camel.component.olingo4.Olingo4Configuration;
import org.apache.camel.component.olingo4.Olingo4Consumer;
import org.apache.camel.component.olingo4.Olingo4Producer;
import org.apache.camel.component.olingo4.internal.Olingo4ApiCollection;
import org.apache.camel.component.olingo4.internal.Olingo4ApiName;
import org.apache.camel.component.olingo4.internal.Olingo4PropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;

@UriEndpoint(firstVersion="2.19.0", scheme="olingo4", title="Olingo4", syntax="olingo4:apiName/methodName", consumerClass=Olingo4Consumer.class, label="cloud")
public class Olingo4Endpoint
extends AbstractApiEndpoint<Olingo4ApiName, Olingo4Configuration> {
    protected static final String RESOURCE_PATH_PROPERTY = "resourcePath";
    protected static final String RESPONSE_HANDLER_PROPERTY = "responseHandler";
    protected static final String SERVICE_URI_PROPERTY = "serviceUri";
    private static final String KEY_PREDICATE_PROPERTY = "keyPredicate";
    private static final String QUERY_PARAMS_PROPERTY = "queryParams";
    private static final String ENDPOINT_HTTP_HEADERS_PROPERTY = "endpointHttpHeaders";
    private static final String READ_METHOD = "read";
    private static final String EDM_PROPERTY = "edm";
    private static final String DATA_PROPERTY = "data";
    private static final String DELETE_METHOD = "delete";
    private static final String UREAD_METHOD = "uread";
    private final Set<String> endpointPropertyNames;
    @UriParam
    private Olingo4Configuration configuration;
    private Olingo4AppWrapper apiProxy;

    public Olingo4Endpoint(String uri, Olingo4Component component, Olingo4ApiName apiName, String methodName, Olingo4Configuration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, Olingo4ApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
        this.endpointPropertyNames = new HashSet<String>(this.getPropertiesHelper().getValidEndpointProperties((Object)this.configuration));
        this.endpointPropertyNames.add(EDM_PROPERTY);
        this.endpointPropertyNames.add(ENDPOINT_HTTP_HEADERS_PROPERTY);
        this.endpointPropertyNames.add(SERVICE_URI_PROPERTY);
    }

    public Producer createProducer() throws Exception {
        return new Olingo4Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        if (!READ_METHOD.equals(this.methodName) && !UREAD_METHOD.equals(this.methodName)) {
            throw new IllegalArgumentException("Only read method is supported for consumer endpoints");
        }
        Olingo4Consumer consumer = new Olingo4Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<Olingo4Configuration> getPropertiesHelper() {
        return Olingo4PropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelOlingo4";
    }

    public void configureProperties(Map<String, Object> options) {
        this.parseQueryParams(options);
        super.configureProperties(options);
    }

    protected void afterConfigureProperties() {
        if (!(READ_METHOD.equals(this.methodName) || DELETE_METHOD.equals(this.methodName) || UREAD_METHOD.equals(this.methodName) || this.inBody != null)) {
            this.inBody = DATA_PROPERTY;
        }
        this.createProxy();
    }

    public synchronized Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy.getOlingo4App();
    }

    public Olingo4Component getComponent() {
        return (Olingo4Component)super.getComponent();
    }

    protected void doStart() throws Exception {
        if (this.apiProxy == null) {
            this.createProxy();
        }
    }

    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            this.getComponent().closeApiProxy(this.apiProxy);
            this.apiProxy = null;
        }
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        if (!DELETE_METHOD.equals(this.methodName)) {
            propertyNames.add(EDM_PROPERTY);
        }
        propertyNames.add(RESPONSE_HANDLER_PROPERTY);
    }

    public void interceptProperties(Map<String, Object> properties) {
        properties.put(EDM_PROPERTY, this.apiProxy.getEdm());
        String keyPredicate = (String)properties.get(KEY_PREDICATE_PROPERTY);
        if (keyPredicate != null) {
            String resourcePath = (String)properties.get(RESOURCE_PATH_PROPERTY);
            if (resourcePath == null) {
                throw new IllegalArgumentException("Resource path must be provided in endpoint URI, or URI parameter 'resourcePath', or exchange header 'CamelOlingo4.resourcePath'");
            }
            properties.put(RESOURCE_PATH_PROPERTY, resourcePath + '(' + keyPredicate + ')');
        }
        this.parseQueryParams(properties);
    }

    private void createProxy() {
        this.apiProxy = this.getComponent().createApiProxy((Olingo4Configuration)this.getConfiguration());
    }

    private void parseQueryParams(Map<String, Object> options) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        Iterator<Map.Entry<String, Object>> it = options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String paramName = entry.getKey();
            if (paramName.startsWith("consumer.") || this.endpointPropertyNames.contains(paramName)) continue;
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Null value for query parameter " + paramName);
            }
            queryParams.put(paramName, value.toString());
            it.remove();
        }
        if (!queryParams.isEmpty()) {
            Map oldParams = (Map)options.get(QUERY_PARAMS_PROPERTY);
            if (oldParams == null) {
                options.put(QUERY_PARAMS_PROPERTY, queryParams);
            } else {
                oldParams.putAll(queryParams);
            }
        }
    }
}

