/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import org.apache.camel.generator.openapi.AppendableGenerator;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.DirectToOperationId;
import org.apache.camel.generator.openapi.FilerGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathGenerator;
import org.apache.camel.generator.openapi.RestDslDefinitionGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestDslGenerator<G> {
    private static final Logger LOG = LoggerFactory.getLogger(RestDslGenerator.class);
    final OasDocument openapi;
    DestinationGenerator destinationGenerator = new DirectToOperationId();
    OperationFilter filter = new OperationFilter();
    String restComponent;
    String restContextPath;
    String apiContextPath;
    boolean springComponent;
    boolean springBootProject;

    RestDslGenerator(OasDocument openapi) {
        this.openapi = (OasDocument)ObjectHelper.notNull((Object)openapi, (String)"openapi");
    }

    public G withDestinationGenerator(DestinationGenerator directRouteGenerator) {
        ObjectHelper.notNull((Object)directRouteGenerator, (String)"directRouteGenerator");
        this.destinationGenerator = directRouteGenerator;
        RestDslGenerator that = this;
        return (G)that;
    }

    DestinationGenerator destinationGenerator() {
        return this.destinationGenerator;
    }

    public G withOperationFilter(OperationFilter filter) {
        this.filter = filter;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(String include) {
        this.filter.setIncludes(include);
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestComponent(String restComponent) {
        this.restComponent = restComponent;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestContextPath(String contextPath) {
        this.restContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringComponent() {
        this.springComponent = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringBootProject() {
        this.springBootProject = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public static RestDslSourceCodeGenerator<Appendable> toAppendable(OasDocument openapi) {
        return new AppendableGenerator(openapi);
    }

    public static RestDslDefinitionGenerator toDefinition(OasDocument openapi) {
        return new RestDslDefinitionGenerator(openapi);
    }

    public static RestDslXmlGenerator toXml(OasDocument openapi) {
        return new RestDslXmlGenerator(openapi);
    }

    public static RestDslSourceCodeGenerator<Filer> toFiler(OasDocument openapi) {
        return new FilerGenerator(openapi);
    }

    public static RestDslSourceCodeGenerator<Path> toPath(OasDocument openapi) {
        return new PathGenerator(openapi);
    }

    public static String getHostFromOasDocument(OasDocument openapi) {
        String host = null;
        if (openapi instanceof Oas20Document) {
            host = ((Oas20Document)openapi).host;
        } else if (openapi instanceof Oas30Document && ((Oas30Document)openapi).getServers() != null && ((Oas30Document)openapi).getServers().get(0) != null) {
            try {
                URL serverUrl = new URL(RestDslGenerator.parseVariables(((Server)((Oas30Document)openapi).getServers().get((int)0)).url, (Oas30Server)((Oas30Document)openapi).getServers().get(0)));
                host = serverUrl.getHost();
            }
            catch (MalformedURLException e) {
                LOG.info("error when parsing OpenApi 3.0 doc server url", (Throwable)e);
            }
        }
        return host;
    }

    public static String getBasePathFromOasDocument(OasDocument openapi) {
        String basePath = null;
        if (openapi instanceof Oas20Document) {
            basePath = ((Oas20Document)openapi).basePath;
        } else if (openapi instanceof Oas30Document && ((Oas30Document)openapi).getServers() != null && ((Oas30Document)openapi).getServers().get(0) != null) {
            try {
                Oas30Server server = (Oas30Server)((Oas30Document)openapi).getServers().get(0);
                if (server.variables != null && server.variables.get("basePath") != null) {
                    basePath = ((ServerVariable)server.variables.get((Object)"basePath")).default_;
                }
                if (basePath == null) {
                    URL serverUrl = new URL(RestDslGenerator.parseVariables(((Server)((Oas30Document)openapi).getServers().get((int)0)).url, server));
                    basePath = serverUrl.getPath();
                    if (basePath.indexOf("//") == 0) {
                        basePath = basePath.substring(1);
                    }
                    if ("/".equals(basePath)) {
                        basePath = "";
                    }
                }
            }
            catch (MalformedURLException e) {
                basePath = ((Server)((Oas30Document)openapi).getServers().get((int)0)).url;
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Oas30Server server) {
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String var = m.group(1);
            if (server == null || server.variables == null || server.variables.get(var) == null) continue;
            String varValue = ((ServerVariable)server.variables.get((Object)var)).default_;
            url = url.replace("{" + var + "}", varValue);
        }
        return url;
    }
}

