/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasInfo;
import java.io.IOException;
import java.time.Instant;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.generator.openapi.MethodBodySourceCodeEmitter;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public abstract class RestDslSourceCodeGenerator<T>
extends RestDslGenerator<RestDslSourceCodeGenerator<T>> {
    static final String DEFAULT_CLASS_NAME = "RestDslRoute";
    static final String DEFAULT_PACKAGE_NAME = "rest.dsl.generated";
    private static final String DEFAULT_INDENT = "    ";
    private Function<OasDocument, String> classNameGenerator = RestDslSourceCodeGenerator::generateClassName;
    private Instant generated = Instant.now();
    private String indent = "    ";
    private Function<OasDocument, String> packageNameGenerator = RestDslSourceCodeGenerator::generatePackageName;
    private boolean sourceCodeTimestamps;

    RestDslSourceCodeGenerator(OasDocument document) {
        super(document);
    }

    public abstract void generate(T var1) throws IOException;

    public RestDslSourceCodeGenerator<T> withClassName(String className) {
        StringHelper.notEmpty((String)className, (String)"className");
        this.classNameGenerator = s -> className;
        return this;
    }

    public RestDslSourceCodeGenerator<T> withIndent(String indent) {
        this.indent = (String)ObjectHelper.notNull((Object)indent, (String)"indent");
        return this;
    }

    public RestDslSourceCodeGenerator<T> withoutSourceCodeTimestamps() {
        this.sourceCodeTimestamps = false;
        return this;
    }

    public RestDslSourceCodeGenerator<T> withPackageName(String packageName) {
        StringHelper.notEmpty((String)packageName, (String)"packageName");
        this.packageNameGenerator = s -> packageName;
        return this;
    }

    public RestDslSourceCodeGenerator<T> withSourceCodeTimestamps() {
        this.sourceCodeTimestamps = true;
        return this;
    }

    MethodSpec generateConfigureMethod(OasDocument document) {
        MethodSpec.Builder configure = MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addJavadoc("Defines Apache Camel routes using REST DSL fluent API.\n", new Object[0]);
        MethodBodySourceCodeEmitter emitter = new MethodBodySourceCodeEmitter(configure);
        if (this.restComponent != null) {
            configure.addCode("\n", new Object[0]);
            configure.addCode("restConfiguration().component(\"" + this.restComponent + "\")", new Object[0]);
            if (this.restContextPath != null) {
                configure.addCode(".contextPath(\"" + this.restContextPath + "\")", new Object[0]);
            }
            if (ObjectHelper.isNotEmpty((Object)this.apiContextPath)) {
                configure.addCode(".apiContextPath(\"" + this.apiContextPath + "\")", new Object[0]);
            }
            configure.addCode(";\n\n", new Object[0]);
        }
        String basePath = RestDslGenerator.determineBasePathFrom(document);
        PathVisitor<MethodSpec> restDslStatement = new PathVisitor<MethodSpec>(basePath, emitter, this.filter, this.destinationGenerator());
        document.paths.getItems().forEach(restDslStatement::visit);
        return emitter.result();
    }

    Instant generated() {
        return this.generated;
    }

    JavaFile generateSourceCode() {
        MethodSpec methodSpec = this.generateConfigureMethod(this.document);
        String classNameToUse = this.classNameGenerator.apply(this.document);
        AnnotationSpec.Builder generatedAnnotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.getClass().getName()});
        if (this.sourceCodeTimestamps) {
            generatedAnnotation.addMember("date", "$S", new Object[]{this.generated()});
        }
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)classNameToUse).superclass(RouteBuilder.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(methodSpec).addAnnotation(generatedAnnotation.build()).addJavadoc("Generated from OpenApi specification by Camel REST DSL generator.\n", new Object[0]);
        if (this.springComponent) {
            AnnotationSpec.Builder springAnnotation = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.springframework.stereotype.Component"));
            builder.addAnnotation(springAnnotation.build());
        }
        TypeSpec generatedRouteBuilder = builder.build();
        String packageNameToUse = this.packageNameGenerator.apply(this.document);
        return JavaFile.builder((String)packageNameToUse, (TypeSpec)generatedRouteBuilder).indent(this.indent).build();
    }

    RestDslSourceCodeGenerator<T> withGeneratedTime(Instant generated) {
        this.generated = generated;
        return this;
    }

    static String generateClassName(OasDocument document) {
        OasInfo info = (OasInfo)document.info;
        if (info == null) {
            return DEFAULT_CLASS_NAME;
        }
        String title = info.title;
        if (title == null) {
            return DEFAULT_CLASS_NAME;
        }
        String className = title.chars().filter(Character::isJavaIdentifierPart).filter(c -> c < 122).boxed().collect(Collector.of(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        if (className.isEmpty() || !Character.isJavaIdentifierStart(className.charAt(0))) {
            return DEFAULT_CLASS_NAME;
        }
        return className;
    }

    static String generatePackageName(OasDocument document) {
        String host = RestDslGenerator.determineHostFrom(document);
        if (ObjectHelper.isNotEmpty((Object)host)) {
            StringBuilder packageName = new StringBuilder();
            String hostWithoutPort = host.replaceFirst(":.*", "");
            if ("localhost".equalsIgnoreCase(hostWithoutPort)) {
                return DEFAULT_PACKAGE_NAME;
            }
            String[] parts = hostWithoutPort.split("\\.");
            for (int i = parts.length - 1; i >= 0; --i) {
                packageName.append(parts[i]);
                if (i == 0) continue;
                packageName.append('.');
            }
            return packageName.toString();
        }
        return DEFAULT_PACKAGE_NAME;
    }
}

