/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class SpringBootProjectSourceCodeGenerator {
    private static final String DEFAULT_INDENT = "    ";
    private String indent = "    ";
    private String packageName;

    public void generate(Path destination) throws IOException {
        JavaFile javaFile = this.generateSourceCode();
        javaFile.writeTo(destination);
    }

    public SpringBootProjectSourceCodeGenerator withIndent(String indent) {
        this.indent = (String)ObjectHelper.notNull((Object)indent, (String)"indent");
        return this;
    }

    public SpringBootProjectSourceCodeGenerator withPackageName(String packageName) {
        StringHelper.notEmpty((String)packageName, (String)"packageName");
        this.packageName = packageName;
        return this;
    }

    MethodSpec generateRestMethod() {
        ClassName req = ClassName.bestGuess((String)"javax.servlet.http.HttpServletRequest");
        ClassName res = ClassName.bestGuess((String)"javax.servlet.http.HttpServletResponse");
        AnnotationSpec.Builder reqAnnotation = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.springframework.web.bind.annotation.RequestMapping")).addMember("value", "\"/**\"", new Object[0]);
        MethodSpec.Builder forward = MethodSpec.methodBuilder((String)"camelServlet").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)req, "request", new Modifier[0]).addParameter((TypeName)res, "response", new Modifier[0]).addAnnotation(reqAnnotation.build()).returns(Void.TYPE);
        forward.addCode("try {\n", new Object[0]);
        forward.addCode("    String path = request.getRequestURI();\n", new Object[0]);
        forward.addCode("    request.getServletContext().getRequestDispatcher(\"/camel/\" + path).forward(request, response);\n", new Object[0]);
        forward.addCode("} catch (Exception e) {\n", new Object[0]);
        forward.addCode("    response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);\n", new Object[0]);
        forward.addCode("}\n", new Object[0]);
        return forward.build();
    }

    JavaFile generateSourceCode() {
        StringHelper.notEmpty((String)this.packageName, (String)"packageName");
        MethodSpec methodSpec = this.generateRestMethod();
        String classNameToUse = "CamelRestController";
        AnnotationSpec.Builder generatedAnnotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.getClass().getName()});
        AnnotationSpec.Builder restAnnotation = AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"org.springframework.web.bind.annotation.RestController"));
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"CamelRestController").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(methodSpec).addAnnotation(generatedAnnotation.build()).addAnnotation(restAnnotation.build()).addJavadoc("Forward requests to the Camel servlet so it can service REST requests.\n", new Object[0]);
        TypeSpec generatedRestController = builder.build();
        return JavaFile.builder((String)this.packageName, (TypeSpec)generatedRestController).indent(this.indent).build();
    }

    public static SpringBootProjectSourceCodeGenerator generator() {
        return new SpringBootProjectSourceCodeGenerator();
    }
}

