/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.util.ObjectHelper;

class OperationVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String path;

    OperationVisitor(CodeEmitter<T> emitter, OperationFilter filter, String path, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.path = path;
        this.destinationGenerator = destinationGenerator;
    }

    List<String> asStringList(List<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        values.forEach(v -> stringList.add(String.valueOf(v)));
        return stringList;
    }

    CodeEmitter<T> emit(OasParameter parameter) {
        this.emitter.emit("param", new Object[0]);
        OasParameter toUse = parameter;
        if (ObjectHelper.isNotEmpty((Object)parameter.$ref)) {
            toUse = (OasParameter)ReferenceUtil.resolveRef((String)parameter.$ref, (Node)parameter);
        }
        this.emit("name", toUse.getName());
        String parameterType = toUse.in;
        if (ObjectHelper.isNotEmpty((Object)parameterType)) {
            this.emit("type", RestParamType.valueOf((String)parameterType));
        }
        if (!"body".equals(parameterType)) {
            if (toUse instanceof Oas20Parameter) {
                Oas20Parameter serializableParameter = (Oas20Parameter)toUse;
                String dataType = serializableParameter.type;
                this.emit("dataType", dataType);
                this.emit("allowableValues", this.asStringList(serializableParameter.enum_));
                String collectionFormat = serializableParameter.collectionFormat;
                if (ObjectHelper.isNotEmpty((Object)collectionFormat)) {
                    this.emit("collectionFormat", CollectionFormat.valueOf((String)collectionFormat));
                }
                if (ObjectHelper.isNotEmpty((Object)serializableParameter.default_)) {
                    String value = serializableParameter.default_.toString();
                    this.emit("defaultValue", value);
                }
                Oas20Items items = serializableParameter.items;
                if ("array".equals(dataType) && items != null) {
                    this.emit("arrayType", items.type);
                }
            } else if (toUse instanceof Oas30Parameter) {
                Oas30Parameter serializableParameter = (Oas30Parameter)toUse;
                Oas30Schema schema = (Oas30Schema)serializableParameter.schema;
                if (schema != null) {
                    String dataType = schema.type;
                    if (ObjectHelper.isNotEmpty((Object)dataType)) {
                        this.emit("dataType", dataType);
                    }
                    this.emit("allowableValues", this.asStringList(schema.enum_));
                    String style = serializableParameter.style;
                    if (ObjectHelper.isNotEmpty((Object)style) && style.equals("form")) {
                        if (Boolean.FALSE.equals(serializableParameter.explode)) {
                            this.emit("collectionFormat", CollectionFormat.csv);
                        } else {
                            this.emit("collectionFormat", CollectionFormat.multi);
                        }
                    }
                    if (ObjectHelper.isNotEmpty((Object)schema.default_)) {
                        String value = schema.default_.toString();
                        this.emit("defaultValue", value);
                    }
                    if ("array".equals(dataType) && schema.items != null && schema.items instanceof Oas30Schema.Oas30ItemsSchema) {
                        this.emit("arrayType", ((Oas30Schema.Oas30ItemsSchema)schema.items).type);
                    }
                }
            }
        }
        if (toUse.required != null) {
            this.emit("required", toUse.required);
        } else {
            this.emit("required", Boolean.FALSE);
        }
        this.emit("description", toUse.description);
        this.emitter.emit("endParam", new Object[0]);
        return this.emitter;
    }

    CodeEmitter<T> emit(String method, List<String> values) {
        if (values == null || values.isEmpty()) {
            return this.emitter;
        }
        return this.emitter.emit(method, new Object[]{values.toArray(new String[values.size()])});
    }

    CodeEmitter<T> emit(String method, Object value) {
        if (ObjectHelper.isEmpty((Object)value)) {
            return this.emitter;
        }
        return this.emitter.emit(method, value);
    }

    void visit(PathVisitor.HttpMethod method, OasOperation operation) {
        if (this.filter.accept(operation.operationId)) {
            OasPathItem pathItem;
            String methodName = method.name().toLowerCase();
            this.emitter.emit(methodName, this.path);
            this.emit("id", operation.operationId);
            this.emit("description", operation.description);
            ArrayList<String> operationLevelConsumes = new ArrayList();
            if (operation instanceof Oas20Operation) {
                operationLevelConsumes = ((Oas20Operation)operation).consumes;
            } else if (operation instanceof Oas30Operation) {
                Oas30Operation oas30Operation = (Oas30Operation)operation;
                if (oas30Operation.requestBody != null && oas30Operation.requestBody.content != null) {
                    for (String ct : oas30Operation.requestBody.content.keySet()) {
                        operationLevelConsumes.add(ct);
                    }
                }
            }
            this.emit("consumes", operationLevelConsumes);
            ArrayList<String> operationLevelProduces = new ArrayList();
            if (operation instanceof Oas20Operation) {
                operationLevelProduces = ((Oas20Operation)operation).produces;
            } else if (operation instanceof Oas30Operation) {
                Oas30Operation oas30Operation = (Oas30Operation)operation;
                if (oas30Operation.responses != null) {
                    for (OasResponse response : oas30Operation.responses.getResponses()) {
                        Oas30Response oas30Response = (Oas30Response)response;
                        for (String ct : oas30Response.content.keySet()) {
                            operationLevelProduces.add(ct);
                        }
                    }
                }
            }
            this.emit("produces", operationLevelProduces);
            if (ObjectHelper.isNotEmpty((Object)operation.getParameters())) {
                operation.getParameters().forEach(this::emit);
            }
            if (ObjectHelper.isNotEmpty((Object)(pathItem = (OasPathItem)operation.parent()).getParameters())) {
                pathItem.getParameters().forEach(this::emit);
            }
            if (operation instanceof Oas30Operation) {
                this.emitOas30Operation((Oas30Operation)operation);
            }
            this.emitter.emit("to", this.destinationGenerator.generateDestinationFor(operation));
        }
    }

    private CodeEmitter<T> emitOas30Operation(Oas30Operation operation) {
        if (operation.requestBody != null) {
            boolean foundForm = false;
            Oas30RequestBody requestBody = operation.requestBody;
            for (Map.Entry entry : requestBody.content.entrySet()) {
                String ct = (String)entry.getKey();
                Oas30MediaType mediaType = (Oas30MediaType)entry.getValue();
                if (!ct.contains("form") || mediaType.schema.properties == null) continue;
                for (Map.Entry entrySchema : mediaType.schema.properties.entrySet()) {
                    foundForm = true;
                    this.emitter.emit("param", new Object[0]);
                    this.emit("name", entrySchema.getKey());
                    this.emit("type", RestParamType.formData);
                    this.emit("dataType", ((OasSchema)entrySchema.getValue()).type);
                    this.emit("required", requestBody.required);
                    this.emit("description", ((OasSchema)entrySchema.getValue()).description);
                    this.emitter.emit("endParam", new Object[0]);
                }
            }
            if (!foundForm) {
                this.emitter.emit("param", new Object[0]);
                this.emit("name", "body");
                this.emit("type", RestParamType.valueOf((String)"body"));
                this.emit("required", Boolean.TRUE);
                this.emit("description", requestBody.description);
                this.emitter.emit("endParam", new Object[0]);
            }
        }
        return this.emitter;
    }
}

