/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Items;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Operation;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaType;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Operation;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30RequestBody;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Response;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.refs.ReferenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

class OperationVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String path;

    OperationVisitor(CodeEmitter<T> emitter, OperationFilter filter, String path, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.path = path;
        this.destinationGenerator = destinationGenerator;
    }

    List<String> asStringList(List<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        values.forEach(v -> {
            String s = String.valueOf(v);
            s = StringHelper.removeLeadingAndEndingQuotes((String)s);
            stringList.add(s);
        });
        return stringList;
    }

    CodeEmitter<T> emit(OpenApiParameter parameter) {
        String ref;
        this.emitter.emit("param", new Object[0]);
        OpenApiParameter toUse = parameter;
        if (toUse instanceof OpenApi20Parameter) {
            ref = ((OpenApi20Parameter)toUse).get$ref();
            if (ObjectHelper.isNotEmpty((String)ref)) {
                toUse = (OpenApi20Parameter)ReferenceUtil.resolveRef((String)ref, (Node)parameter);
            }
        } else if (toUse instanceof OpenApi30Parameter && ObjectHelper.isNotEmpty((String)(ref = ((OpenApi30Parameter)toUse).get$ref()))) {
            toUse = (OpenApi30Parameter)ReferenceUtil.resolveRef((String)ref, (Node)parameter);
        }
        this.emit("name", toUse.getName());
        String parameterType = toUse.getIn();
        if (ObjectHelper.isNotEmpty((String)parameterType)) {
            this.emit("type", RestParamType.valueOf((String)parameterType));
        }
        if (!"body".equals(parameterType)) {
            OpenApi30Parameter serializableParameter;
            OpenApi30Schema schema;
            if (toUse instanceof OpenApi20Parameter) {
                OpenApi20Parameter serializableParameter2 = (OpenApi20Parameter)toUse;
                String dataType = serializableParameter2.getType();
                this.emit("dataType", dataType);
                this.emit("allowableValues", this.asStringList(serializableParameter2.getEnum()));
                String collectionFormat = serializableParameter2.getCollectionFormat();
                if (ObjectHelper.isNotEmpty((String)collectionFormat)) {
                    this.emit("collectionFormat", CollectionFormat.valueOf((String)collectionFormat));
                }
                if (ObjectHelper.isNotEmpty((Object)serializableParameter2.getDefault())) {
                    String value = StringHelper.removeLeadingAndEndingQuotes((String)serializableParameter2.getDefault().toString());
                    this.emit("defaultValue", value);
                }
                OpenApi20Items items = serializableParameter2.getItems();
                if ("array".equals(dataType) && items != null) {
                    this.emit("arrayType", items.getType());
                }
            } else if (toUse instanceof OpenApi30Parameter && (schema = (OpenApi30Schema)(serializableParameter = (OpenApi30Parameter)toUse).getSchema()) != null) {
                String dataType = schema.getType();
                if (ObjectHelper.isNotEmpty((String)dataType)) {
                    this.emit("dataType", dataType);
                }
                this.emit("allowableValues", this.asStringList(schema.getEnum()));
                String style = serializableParameter.getStyle();
                if (ObjectHelper.isNotEmpty((String)style) && style.equals("form")) {
                    if (Boolean.FALSE.equals(serializableParameter.isExplode())) {
                        this.emit("collectionFormat", CollectionFormat.csv);
                    } else {
                        this.emit("collectionFormat", CollectionFormat.multi);
                    }
                }
                if (ObjectHelper.isNotEmpty((Object)schema.getDefault())) {
                    String value = StringHelper.removeLeadingAndEndingQuotes((String)schema.getDefault().toString());
                    this.emit("defaultValue", value);
                }
                if ("array".equals(dataType) && schema.getItems() != null) {
                    this.emit("arrayType", schema.getItems().getType());
                }
            }
        }
        if (toUse.isRequired() != null) {
            this.emit("required", toUse.isRequired());
        } else {
            this.emit("required", Boolean.FALSE);
        }
        this.emit("description", toUse.getDescription());
        this.emitter.emit("endParam", new Object[0]);
        return this.emitter;
    }

    CodeEmitter<T> emit(String method, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this.emitter;
        }
        return this.emitter.emit(method, new Object[]{values.toArray(new String[0])});
    }

    CodeEmitter<T> emit(String method, Object value) {
        if (ObjectHelper.isEmpty((Object)value)) {
            return this.emitter;
        }
        return this.emitter.emit(method, value);
    }

    void visit(PathVisitor.HttpMethod method, OpenApiOperation operation) {
        if (this.filter.accept(operation.getOperationId())) {
            OpenApiPathItem pathItem;
            OpenApi30Operation oas30Operation;
            OpenApi30Operation oas30Operation2;
            String methodName = method.name().toLowerCase();
            this.emitter.emit(methodName, this.path);
            this.emit("id", operation.getOperationId());
            this.emit("description", operation.getDescription());
            LinkedHashSet<String> operationLevelConsumes = new LinkedHashSet<String>();
            if (operation instanceof OpenApi20Operation) {
                OpenApi20Operation oas20Operation = (OpenApi20Operation)operation;
                if (oas20Operation.getConsumes() != null) {
                    operationLevelConsumes.addAll(oas20Operation.getConsumes());
                }
            } else if (operation instanceof OpenApi30Operation && (oas30Operation2 = (OpenApi30Operation)operation).getRequestBody() != null && oas30Operation2.getRequestBody().getContent() != null) {
                operationLevelConsumes.addAll(oas30Operation2.getRequestBody().getContent().keySet());
            }
            this.emit("consumes", operationLevelConsumes);
            LinkedHashSet<String> operationLevelProduces = new LinkedHashSet<String>();
            if (operation instanceof OpenApi20Operation) {
                OpenApi20Operation oas20Operation = (OpenApi20Operation)operation;
                if (oas20Operation.getProduces() != null) {
                    operationLevelProduces.addAll(oas20Operation.getProduces());
                }
            } else if (operation instanceof OpenApi30Operation && (oas30Operation = (OpenApi30Operation)operation).getResponses() != null) {
                for (OpenApiResponse response : oas30Operation.getResponses().getItems()) {
                    OpenApi30Response oas30Response = (OpenApi30Response)response;
                    if (oas30Response.getContent() == null) continue;
                    operationLevelProduces.addAll(oas30Response.getContent().keySet());
                }
                OpenApi30Response oas30Response = (OpenApi30Response)oas30Operation.getResponses().getDefault();
                if (oas30Response != null && oas30Response.getContent() != null) {
                    operationLevelProduces.addAll(oas30Response.getContent().keySet());
                }
            }
            this.emit("produces", operationLevelProduces);
            if (ObjectHelper.isNotEmpty((Collection)operation.getParameters())) {
                operation.getParameters().forEach(this::emit);
            }
            if (ObjectHelper.isNotEmpty((Collection)(pathItem = (OpenApiPathItem)operation.parent()).getParameters())) {
                pathItem.getParameters().forEach(this::emit);
            }
            if (operation instanceof OpenApi30Operation) {
                this.emitOas30Operation((OpenApi30Operation)operation);
            }
            this.emitter.emit("to", this.destinationGenerator.generateDestinationFor(operation));
        }
    }

    private CodeEmitter<T> emitOas30Operation(OpenApi30Operation operation) {
        if (operation.getRequestBody() != null) {
            boolean foundForm = false;
            OpenApi30RequestBody requestBody = operation.getRequestBody();
            for (Map.Entry entry : requestBody.getContent().entrySet()) {
                String ct = (String)entry.getKey();
                OpenApi30MediaType mediaType = (OpenApi30MediaType)entry.getValue();
                if (!ct.contains("form") || mediaType.getSchema().getProperties() == null) continue;
                for (Map.Entry entrySchema : mediaType.getSchema().getProperties().entrySet()) {
                    OpenApi30Schema openApi30Schema = (OpenApi30Schema)entrySchema.getValue();
                    foundForm = true;
                    this.emitter.emit("param", new Object[0]);
                    this.emit("name", entrySchema.getKey());
                    this.emit("type", RestParamType.formData);
                    this.emit("dataType", openApi30Schema.getType());
                    this.emit("required", requestBody.isRequired());
                    this.emit("description", ((Schema)entrySchema.getValue()).getDescription());
                    this.emitter.emit("endParam", new Object[0]);
                }
            }
            if (!foundForm) {
                this.emitter.emit("param", new Object[0]);
                this.emit("name", "body");
                this.emit("type", RestParamType.valueOf((String)"body"));
                this.emit("required", Boolean.TRUE);
                this.emit("description", requestBody.getDescription());
                this.emitter.emit("endParam", new Object[0]);
            }
        }
        return this.emitter;
    }
}

