/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.OpenApiSchema;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Items;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Operation;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaType;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Operation;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30RequestBody;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Response;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31MediaType;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Operation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31RequestBody;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Response;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.refs.ReferenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

class OperationVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String path;
    private final String dtoPackageName;

    OperationVisitor(CodeEmitter<T> emitter, OperationFilter filter, String path, DestinationGenerator destinationGenerator, String dtoPackageName) {
        this.emitter = emitter;
        this.filter = filter;
        this.path = path;
        this.destinationGenerator = destinationGenerator;
        this.dtoPackageName = dtoPackageName;
    }

    List<String> asStringList(List<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        values.forEach(v -> {
            String s = String.valueOf(v);
            s = StringHelper.removeLeadingAndEndingQuotes((String)s);
            stringList.add(s);
        });
        return stringList;
    }

    CodeEmitter<T> emit(OpenApiParameter parameter) {
        String ref;
        this.emitter.emit("param", new Object[0]);
        OpenApiParameter toUse = parameter;
        if (toUse instanceof OpenApi20Parameter) {
            ref = ((OpenApi20Parameter)toUse).get$ref();
            if (ObjectHelper.isNotEmpty((String)ref)) {
                toUse = (OpenApi20Parameter)ReferenceUtil.resolveRef((String)ref, (Node)parameter);
            }
        } else if (toUse instanceof OpenApi30Parameter) {
            ref = ((OpenApi30Parameter)toUse).get$ref();
            if (ObjectHelper.isNotEmpty((String)ref)) {
                toUse = (OpenApi30Parameter)ReferenceUtil.resolveRef((String)ref, (Node)parameter);
            }
        } else if (toUse instanceof OpenApi31Parameter && ObjectHelper.isNotEmpty((String)(ref = ((OpenApi31Parameter)toUse).get$ref()))) {
            toUse = (OpenApi31Parameter)ReferenceUtil.resolveRef((String)ref, (Node)parameter);
        }
        this.emit("name", toUse.getName());
        String parameterType = toUse.getIn();
        if (ObjectHelper.isNotEmpty((String)parameterType)) {
            this.emit("type", RestParamType.valueOf((String)parameterType));
        }
        if (!"body".equals(parameterType)) {
            OpenApi31Parameter serializableParameter;
            OpenApi31Schema schema;
            if (toUse instanceof OpenApi20Parameter) {
                OpenApi20Parameter serializableParameter2 = (OpenApi20Parameter)toUse;
                String dataType = serializableParameter2.getType();
                this.emit("dataType", dataType);
                this.emit("allowableValues", this.asStringList(serializableParameter2.getEnum()));
                String collectionFormat = serializableParameter2.getCollectionFormat();
                if (ObjectHelper.isNotEmpty((String)collectionFormat)) {
                    this.emit("collectionFormat", CollectionFormat.valueOf((String)collectionFormat));
                }
                if (ObjectHelper.isNotEmpty((Object)serializableParameter2.getDefault())) {
                    String value = StringHelper.removeLeadingAndEndingQuotes((String)serializableParameter2.getDefault().toString());
                    this.emit("defaultValue", value);
                }
                OpenApi20Items items = serializableParameter2.getItems();
                if ("array".equals(dataType) && items != null) {
                    this.emit("arrayType", items.getType());
                }
            } else if (toUse instanceof OpenApi30Parameter) {
                OpenApi30Parameter serializableParameter3 = (OpenApi30Parameter)toUse;
                OpenApi30Schema schema2 = (OpenApi30Schema)serializableParameter3.getSchema();
                if (schema2 != null) {
                    String dataType = schema2.getType();
                    if (ObjectHelper.isNotEmpty((String)dataType)) {
                        this.emit("dataType", dataType);
                    }
                    this.emit("allowableValues", this.asStringList(schema2.getEnum()));
                    String style = serializableParameter3.getStyle();
                    if (ObjectHelper.isNotEmpty((String)style) && style.equals("form")) {
                        if (Boolean.FALSE.equals(serializableParameter3.isExplode())) {
                            this.emit("collectionFormat", CollectionFormat.csv);
                        } else {
                            this.emit("collectionFormat", CollectionFormat.multi);
                        }
                    }
                    if (ObjectHelper.isNotEmpty((Object)schema2.getDefault())) {
                        String value = StringHelper.removeLeadingAndEndingQuotes((String)schema2.getDefault().toString());
                        this.emit("defaultValue", value);
                    }
                    if ("array".equals(dataType) && schema2.getItems() != null) {
                        this.emit("arrayType", schema2.getItems().getType());
                    }
                }
            } else if (toUse instanceof OpenApi31Parameter && (schema = (OpenApi31Schema)(serializableParameter = (OpenApi31Parameter)toUse).getSchema()) != null) {
                String dataType;
                String string = dataType = schema.getType() != null && schema.getType().isString() ? schema.getType().asString() : null;
                if (ObjectHelper.isNotEmpty(dataType)) {
                    this.emit("dataType", dataType);
                }
                this.emit("allowableValues", this.asStringList(schema.getEnum()));
                String style = serializableParameter.getStyle();
                if (ObjectHelper.isNotEmpty((String)style) && style.equals("form")) {
                    if (Boolean.FALSE.equals(serializableParameter.isExplode())) {
                        this.emit("collectionFormat", CollectionFormat.csv);
                    } else {
                        this.emit("collectionFormat", CollectionFormat.multi);
                    }
                }
                if (ObjectHelper.isNotEmpty((Object)schema.getDefault())) {
                    String value = StringHelper.removeLeadingAndEndingQuotes((String)schema.getDefault().toString());
                    this.emit("defaultValue", value);
                }
                if ("array".equals(dataType) && schema.getItems() != null) {
                    this.emit("arrayType", schema.getItems().getType().asString());
                }
            }
        }
        if (toUse.isRequired() != null) {
            this.emit("required", toUse.isRequired());
        } else {
            this.emit("required", Boolean.FALSE);
        }
        this.emit("description", toUse.getDescription());
        this.emitter.emit("endParam", new Object[0]);
        return this.emitter;
    }

    CodeEmitter<T> emit(String method, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this.emitter;
        }
        return this.emitter.emit(method, new Object[]{values.toArray(new String[0])});
    }

    CodeEmitter<T> emit(String method, Object value) {
        if (ObjectHelper.isEmpty((Object)value)) {
            return this.emitter;
        }
        return this.emitter.emit(method, value);
    }

    void visit(PathVisitor.HttpMethod method, OpenApiOperation operation) {
        if (this.filter.accept(operation.getOperationId())) {
            OpenApiPathItem pathItem;
            OpenApi31Operation oas31Operation;
            OpenApi31Operation oas31Operation2;
            String methodName = method.name().toLowerCase();
            this.emitter.emit(methodName, this.path);
            this.emit("id", operation.getOperationId());
            this.emit("description", operation.getDescription());
            LinkedHashSet<String> operationLevelConsumes = new LinkedHashSet<String>();
            if (operation instanceof OpenApi20Operation) {
                OpenApi20Operation oas20Operation = (OpenApi20Operation)operation;
                if (oas20Operation.getConsumes() != null) {
                    operationLevelConsumes.addAll(oas20Operation.getConsumes());
                }
            } else if (operation instanceof OpenApi30Operation) {
                OpenApi30Operation oas30Operation = (OpenApi30Operation)operation;
                if (oas30Operation.getRequestBody() != null && oas30Operation.getRequestBody().getContent() != null) {
                    operationLevelConsumes.addAll(oas30Operation.getRequestBody().getContent().keySet());
                }
            } else if (operation instanceof OpenApi31Operation && (oas31Operation2 = (OpenApi31Operation)operation).getRequestBody() != null && oas31Operation2.getRequestBody().getContent() != null) {
                operationLevelConsumes.addAll(oas31Operation2.getRequestBody().getContent().keySet());
            }
            this.emit("consumes", operationLevelConsumes);
            LinkedHashSet<String> operationLevelProduces = new LinkedHashSet<String>();
            if (operation instanceof OpenApi20Operation) {
                OpenApi20Operation oas20Operation = (OpenApi20Operation)operation;
                if (oas20Operation.getProduces() != null) {
                    operationLevelProduces.addAll(oas20Operation.getProduces());
                }
            } else if (operation instanceof OpenApi30Operation) {
                OpenApi30Operation oas30Operation = (OpenApi30Operation)operation;
                if (oas30Operation.getResponses() != null) {
                    for (OpenApiResponse response : oas30Operation.getResponses().getItems()) {
                        OpenApi30Response oas30Response = (OpenApi30Response)response;
                        if (oas30Response.getContent() == null) continue;
                        operationLevelProduces.addAll(oas30Response.getContent().keySet());
                    }
                    OpenApi30Response oas30Response = (OpenApi30Response)oas30Operation.getResponses().getDefault();
                    if (oas30Response != null && oas30Response.getContent() != null) {
                        operationLevelProduces.addAll(oas30Response.getContent().keySet());
                    }
                }
            } else if (operation instanceof OpenApi31Operation && (oas31Operation = (OpenApi31Operation)operation).getResponses() != null) {
                for (OpenApiResponse response : oas31Operation.getResponses().getItems()) {
                    OpenApi31Response oas31Response = (OpenApi31Response)response;
                    if (oas31Response.getContent() == null) continue;
                    operationLevelProduces.addAll(oas31Response.getContent().keySet());
                }
                OpenApi31Response oas31Response = (OpenApi31Response)oas31Operation.getResponses().getDefault();
                if (oas31Response != null && oas31Response.getContent() != null) {
                    operationLevelProduces.addAll(oas31Response.getContent().keySet());
                }
            }
            this.emit("produces", operationLevelProduces);
            if (ObjectHelper.isNotEmpty((Collection)operation.getParameters())) {
                operation.getParameters().forEach(this::emit);
            }
            if (ObjectHelper.isNotEmpty((Collection)(pathItem = (OpenApiPathItem)operation.parent()).getParameters())) {
                pathItem.getParameters().forEach(this::emit);
            }
            if (operation instanceof OpenApi30Operation) {
                this.emitOas30Operation((OpenApi30Operation)operation);
            } else if (operation instanceof OpenApi31Operation) {
                this.emitOas31Operation((OpenApi31Operation)operation);
            }
            this.emitter.emit("to", this.destinationGenerator.generateDestinationFor(operation));
        }
    }

    /*
     * WARNING - void declaration
     */
    private CodeEmitter<T> emitOas30Operation(OpenApi30Operation operation) {
        Object dto;
        if (operation.getRequestBody() != null) {
            dto = null;
            boolean foundForm = false;
            OpenApi30RequestBody requestBody = operation.getRequestBody();
            for (Map.Entry entry : requestBody.getContent().entrySet()) {
                String r;
                OpenApiSchema openApiSchema;
                String ct = (String)entry.getKey();
                OpenApi30MediaType mt = (OpenApi30MediaType)entry.getValue();
                if (ct.contains("form") && mt.getSchema().getProperties() != null) {
                    for (Map.Entry entry2 : mt.getSchema().getProperties().entrySet()) {
                        OpenApi30Schema openApi30Schema = (OpenApi30Schema)entry2.getValue();
                        foundForm = true;
                        this.emitter.emit("param", new Object[0]);
                        this.emit("name", entry2.getKey());
                        this.emit("type", RestParamType.formData);
                        this.emit("dataType", openApi30Schema.getType());
                        this.emit("required", requestBody.isRequired());
                        this.emit("description", ((Schema)entry2.getValue()).getDescription());
                        this.emitter.emit("endParam", new Object[0]);
                    }
                }
                if (dto != null || !((openApiSchema = mt.getSchema()) instanceof Referenceable)) continue;
                Referenceable ref = (Referenceable)openApiSchema;
                OpenApi30Schema openApi30Schema = (OpenApi30Schema)mt.getSchema();
                boolean array = "array".equals(openApi30Schema.getType());
                if (array) {
                    ref = openApi30Schema.getItems();
                }
                if ((r = ref.get$ref()) == null || !r.startsWith("#/components/schemas/")) continue;
                dto = r.substring(21);
                if (!array) continue;
                dto = (String)dto + "[]";
            }
            if (!foundForm) {
                this.emitter.emit("param", new Object[0]);
                this.emit("name", "body");
                this.emit("type", RestParamType.valueOf((String)"body"));
                this.emit("required", Boolean.TRUE);
                this.emit("description", requestBody.getDescription());
                this.emitter.emit("endParam", new Object[0]);
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("type", this.dtoPackageName + "." + dto);
            }
        }
        if (operation.getResponses() != null) {
            dto = null;
            for (String key : operation.getResponses().getItemNames()) {
                OpenApiResponse response;
                if (!"200".equals(key) || !((response = (OpenApiResponse)operation.getResponses().getItem(key)) instanceof OpenApi30Response)) continue;
                OpenApi30Response res30 = (OpenApi30Response)response;
                for (Map.Entry entry : res30.getContent().entrySet()) {
                    void var10_18;
                    String r;
                    OpenApiSchema array;
                    OpenApi30MediaType mediaType = (OpenApi30MediaType)entry.getValue();
                    if (dto != null || !((array = mediaType.getSchema()) instanceof Referenceable)) continue;
                    Referenceable referenceable = (Referenceable)array;
                    OpenApi30Schema schema = (OpenApi30Schema)mediaType.getSchema();
                    boolean array2 = "array".equals(schema.getType());
                    if (array2) {
                        OpenApi30Schema openApi30Schema = schema.getItems();
                    }
                    if ((r = var10_18.get$ref()) == null || !r.startsWith("#/components/schemas/")) continue;
                    dto = r.substring(21);
                    if (!array2) continue;
                    dto = (String)dto + "[]";
                }
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("outType", this.dtoPackageName + "." + dto);
            }
        }
        return this.emitter;
    }

    /*
     * WARNING - void declaration
     */
    private CodeEmitter<T> emitOas31Operation(OpenApi31Operation operation) {
        Object dto;
        if (operation.getRequestBody() != null) {
            dto = null;
            boolean foundForm = false;
            OpenApi31RequestBody requestBody = operation.getRequestBody();
            for (Map.Entry entry : requestBody.getContent().entrySet()) {
                String r;
                OpenApiSchema openApiSchema;
                String ct = (String)entry.getKey();
                OpenApi31MediaType mt = (OpenApi31MediaType)entry.getValue();
                if (ct.contains("form") && mt.getSchema().getProperties() != null) {
                    for (Map.Entry entry2 : mt.getSchema().getProperties().entrySet()) {
                        OpenApi31Schema openApi31Schema = (OpenApi31Schema)entry2.getValue();
                        foundForm = true;
                        this.emitter.emit("param", new Object[0]);
                        this.emit("name", entry2.getKey());
                        this.emit("type", RestParamType.formData);
                        this.emit("dataType", openApi31Schema.getType());
                        this.emit("required", requestBody.isRequired());
                        this.emit("description", ((Schema)entry2.getValue()).getDescription());
                        this.emitter.emit("endParam", new Object[0]);
                    }
                }
                if (dto != null || !((openApiSchema = mt.getSchema()) instanceof Referenceable)) continue;
                Referenceable ref = (Referenceable)openApiSchema;
                OpenApi31Schema openApi31Schema = (OpenApi31Schema)mt.getSchema();
                boolean array = "array".equals(openApi31Schema.getType() != null && openApi31Schema.getType().isString() ? openApi31Schema.getType().asString() : Boolean.valueOf(false));
                if (array) {
                    ref = openApi31Schema.getItems();
                }
                if ((r = ref.get$ref()) == null || !r.startsWith("#/components/schemas/")) continue;
                dto = r.substring(21);
                if (!array) continue;
                dto = (String)dto + "[]";
            }
            if (!foundForm) {
                this.emitter.emit("param", new Object[0]);
                this.emit("name", "body");
                this.emit("type", RestParamType.valueOf((String)"body"));
                this.emit("required", Boolean.TRUE);
                this.emit("description", requestBody.getDescription());
                this.emitter.emit("endParam", new Object[0]);
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("type", this.dtoPackageName + "." + dto);
            }
        }
        if (operation.getResponses() != null) {
            dto = null;
            for (String key : operation.getResponses().getItemNames()) {
                OpenApiResponse response;
                if (!"200".equals(key) || !((response = (OpenApiResponse)operation.getResponses().getItem(key)) instanceof OpenApi31Response)) continue;
                OpenApi31Response res31 = (OpenApi31Response)response;
                for (Map.Entry entry : res31.getContent().entrySet()) {
                    void var10_18;
                    String r;
                    OpenApiSchema array;
                    OpenApi31MediaType mediaType = (OpenApi31MediaType)entry.getValue();
                    if (dto != null || !((array = mediaType.getSchema()) instanceof Referenceable)) continue;
                    Referenceable referenceable = (Referenceable)array;
                    OpenApi31Schema schema = (OpenApi31Schema)mediaType.getSchema();
                    boolean array2 = "array".equals(schema.getType() != null && schema.getType().isString() ? schema.getType().asString() : Boolean.valueOf(false));
                    if (array2) {
                        OpenApi31Schema openApi31Schema = schema.getItems();
                    }
                    if ((r = var10_18.get$ref()) == null || !r.startsWith("#/components/schemas/")) continue;
                    dto = r.substring(21);
                    if (!array2) continue;
                    dto = (String)dto + "[]";
                }
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("outType", this.dtoPackageName + "." + dto);
            }
        }
        return this.emitter;
    }
}

