/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.OperationVisitor;
import org.apache.camel.util.ObjectHelper;

class PathVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String dtoPackageName;

    PathVisitor(String basePath, CodeEmitter<T> emitter, OperationFilter filter, DestinationGenerator destinationGenerator, String dtoPackageName) {
        this.emitter = emitter;
        this.filter = filter;
        this.destinationGenerator = destinationGenerator;
        this.dtoPackageName = dtoPackageName;
        if (ObjectHelper.isEmpty((String)basePath)) {
            emitter.emit("rest", new Object[0]);
        } else {
            emitter.emit("rest", basePath);
        }
    }

    void visit(String path, PathItem definition) {
        OperationVisitor restDslOperation = new OperationVisitor(this.emitter, this.filter, path, this.destinationGenerator, this.dtoPackageName);
        definition.readOperationsMap().forEach((method, op) -> restDslOperation.visit((PathItem.HttpMethod)method, (Operation)op, definition));
    }
}

